/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Definition {
    protected String inherit;
    protected String name = null;
    protected String template = null;
    protected Map<String, Attribute> attributes = null;
    protected String role = null;
    protected String preparer = null;

    public Definition() {
        this.attributes = new HashMap<String, Attribute>();
    }

    public Definition(Definition definition) {
        this.attributes = new HashMap<String, Attribute>(definition.getAttributes());
        this.name = definition.getName();
        this.template = definition.getTemplate();
        this.role = definition.getRole();
        this.preparer = definition.getPreparer();
        this.inherit = definition.getExtends();
    }

    public Definition(String name, String template, Map<String, Attribute> attributes) {
        this.name = name;
        this.template = template;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void putAttribute(String key, Attribute value) {
        this.attributes.put(key, value);
    }

    public void addAttribute(Attribute attribute) {
        this.putAttribute(attribute.getName(), attribute);
    }

    public boolean hasAttributeValue(String key) {
        return this.attributes.containsKey(key);
    }

    public void put(String name, Object content) {
        this.put(name, content, null);
    }

    public void put(String name, Object content, String role) {
        this.put(name, content, null, role);
    }

    public void put(String name, Object content, Attribute.AttributeType type, String role) {
        Attribute attribute = new Attribute(content, role, type);
        this.putAttribute(name, attribute);
    }

    public String getPreparer() {
        return this.preparer;
    }

    public void setPreparer(String url) {
        this.preparer = url;
    }

    public void setExtends(String name) {
        this.inherit = name;
    }

    public String getExtends() {
        return this.inherit;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean isExtending() {
        return this.inherit != null;
    }

    public String toString() {
        return "{name=" + this.name + ", template=" + this.template + ", role=" + this.role + ", preparerInstance=" + this.preparer + ", attributes=" + this.attributes + "}\n";
    }
}

