/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.file.Matcher;
import org.apache.tomcat.util.res.StringManager;

public class StandardJarScanner
implements JarScanner {
    private static final Log log = LogFactory.getLog(StandardJarScanner.class);
    private static final Set<String> defaultJarsToSkip = new HashSet<String>();
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.scan");
    private boolean scanClassPath = true;
    private boolean scanAllFiles = false;
    private boolean scanAllDirectories = false;

    public boolean isScanClassPath() {
        return this.scanClassPath;
    }

    public void setScanClassPath(boolean scanClassPath) {
        this.scanClassPath = scanClassPath;
    }

    public boolean isScanAllFiles() {
        return this.scanAllFiles;
    }

    public void setScanAllFiles(boolean scanAllFiles) {
        this.scanAllFiles = scanAllFiles;
    }

    public boolean isScanAllDirectories() {
        return this.scanAllDirectories;
    }

    public void setScanAllDirectories(boolean scanAllDirectories) {
        this.scanAllDirectories = scanAllDirectories;
    }

    @Override
    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        Set<String> ignoredJars = jarsToSkip == null ? defaultJarsToSkip : jarsToSkip;
        HashSet<String[]> ignoredJarsTokens = new HashSet<String[]>();
        for (String pattern : ignoredJars) {
            ignoredJarsTokens.add(Matcher.tokenizePathAsArray(pattern));
        }
        Set dirList = context.getResourcePaths("/WEB-INF/lib/");
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith(".jar") && !Matcher.matchPath(ignoredJarsTokens, path.substring(path.lastIndexOf(47) + 1))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("jarScan.webinflibJarScan", path));
                    }
                    URL url = null;
                    try {
                        String realPath = context.getRealPath(path);
                        url = realPath == null ? context.getResource(path) : new File(realPath).toURI().toURL();
                        this.process(callback, url);
                    }
                    catch (IOException e) {
                        log.warn((Object)sm.getString("jarScan.webinflibFail", url), (Throwable)e);
                    }
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", path));
            }
        }
        if (this.scanClassPath) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("jarScan.classloaderStart"));
            }
            for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
                if (!(loader instanceof URLClassLoader)) continue;
                URL[] urls = ((URLClassLoader)loader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    String jarName = this.getJarName(urls[i]);
                    if (jarName != null && !Matcher.matchPath(ignoredJarsTokens, jarName) && !urls[i].toString().contains("/WEB-INF/lib/" + jarName)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("jarScan.classloaderJarScan", urls[i]));
                        }
                        try {
                            this.process(callback, urls[i]);
                        }
                        catch (IOException ioe) {
                            log.warn((Object)sm.getString("jarScan.classloaderFail", urls[i]), (Throwable)ioe);
                        }
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", urls[i]));
                }
            }
        }
    }

    private void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.jarUrlStart", url));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && this.scanAllFiles) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && this.scanAllDirectories && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }

    private String getJarName(URL url) {
        String name = null;
        String path = url.getPath();
        int end = path.indexOf(".jar");
        if (end != -1) {
            int start = path.lastIndexOf(47, end);
            name = path.substring(start + 1, end + 4);
        } else if (this.isScanAllDirectories()) {
            int start = path.lastIndexOf(47);
            name = path.substring(start + 1);
        }
        return name;
    }

    static {
        String jarList = System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip");
        if (jarList != null) {
            StringTokenizer tokenizer = new StringTokenizer(jarList, ",");
            while (tokenizer.hasMoreElements()) {
                defaultJarsToSkip.add(tokenizer.nextToken());
            }
        }
    }
}

