/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.ndatasource.core.DataSourceAxis2ConfigurationContextObserver;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DataSourceServiceComponent {
    private static final Log log = LogFactory.getLog(DataSourceServiceComponent.class);
    private static RegistryService registryService;
    private static RealmService realmService;
    private static SecretCallbackHandlerService secretCallbackHandlerService;
    private static ServerConfigurationService serverConfigurationService;
    private DataSourceService dataSourceService;
    private ComponentContext ctx;
    private boolean tenantUserDataSourcesInitialized;
    private static ConfigurationContextService configContextService;

    protected synchronized void activate(ComponentContext ctx) {
        this.ctx = ctx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceServiceComponent activated");
        }
        if (this.tenantUserDataSourcesInitialized) {
            this.registerServices();
        }
    }

    protected synchronized void deactivate(ComponentContext ctx) {
        this.ctx = null;
        this.tenantUserDataSourcesInitialized = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceServiceComponent deactivated");
        }
    }

    private void registerServices() {
        if (this.getDataSourceService() == null) {
            this.dataSourceService = new DataSourceService();
        }
        BundleContext bundleContext = this.ctx.getBundleContext();
        bundleContext.registerService(DataSourceService.class.getName(), (Object)this.getDataSourceService(), null);
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DataSourceAxis2ConfigurationContextObserver(), null);
    }

    public DataSourceService getDataSourceService() {
        return this.dataSourceService;
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService acquired");
        }
        DataSourceServiceComponent.realmService = realmService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetRealmService(RealmService realmService) {
        DataSourceServiceComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService acquired");
        }
        DataSourceServiceComponent.registryService = registryService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static SecretCallbackHandlerService getSecretCallbackHandlerService() {
        return secretCallbackHandlerService;
    }

    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService acquired");
        }
        DataSourceServiceComponent.secretCallbackHandlerService = secretCallbackHandlerService;
        this.initSystemDataSources();
        this.checkInitTenantUserDataSources();
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        DataSourceServiceComponent.secretCallbackHandlerService = null;
    }

    private void initSystemDataSources() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing system data sources...");
        }
        try {
            DataSourceManager.getInstance().initSystemDataSources();
            if (log.isDebugEnabled()) {
                log.debug((Object)"System data sources successfully initialized");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in intializing system data sources: " + e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void checkInitTenantUserDataSources() {
        if (DataSourceServiceComponent.getRealmService() != null && DataSourceServiceComponent.getRegistryService() != null && DataSourceServiceComponent.getSecretCallbackHandlerService() != null && DataSourceServiceComponent.getServerConfigurationService() != null) {
            this.initSuperTenantUserDataSources();
        }
    }

    private synchronized void initSuperTenantUserDataSources() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing super tenant user data sources...");
            }
            DataSourceManager.getInstance().initTenant(-1234);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Super tenant user data sources successfully initialized");
            }
            this.tenantUserDataSourcesInitialized = true;
            if (this.ctx != null) {
                this.registerServices();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in intializing system data sources: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean isTenantUserDataSourcesInitialized() {
        return this.tenantUserDataSourcesInitialized;
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        DataSourceServiceComponent.serverConfigurationService = null;
    }

    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServerConfigurationService acquired");
        }
        DataSourceServiceComponent.serverConfigurationService = serverConfigurationService;
        this.checkInitTenantUserDataSources();
    }

    protected void setConfigurationContextService(ConfigurationContextService configContextService) {
        DataSourceServiceComponent.configContextService = configContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configContextService) {
        DataSourceServiceComponent.configContextService = null;
    }

    public static ConfigurationContextService getConfigContextService() {
        return configContextService;
    }
}

