/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectMemoryData;

public class FileObjectMemory
implements FileObject {
    private final FileObjectMemoryData data;
    private long pos;

    FileObjectMemory(FileObjectMemoryData fileObjectMemoryData) {
        this.data = fileObjectMemoryData;
    }

    @Override
    public long length() {
        return this.data.length();
    }

    @Override
    public void setFileLength(long l) throws IOException {
        this.data.touch();
        if (l < this.length()) {
            this.pos = Math.min(this.pos, l);
        }
        this.data.setFileLength(l);
    }

    @Override
    public void seek(long l) {
        this.pos = (int)l;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.data.touch();
        this.pos = this.data.readWrite(this.pos, byArray, n, n2, true);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.pos = this.data.readWrite(this.pos, byArray, n, n2, false);
    }

    @Override
    public long getFilePointer() {
        return this.pos;
    }

    @Override
    public void close() {
        this.pos = 0L;
    }

    @Override
    public void sync() {
    }

    public void setName(String string) {
        this.data.setName(string);
    }

    @Override
    public String getName() {
        return this.data.getName();
    }

    public long getLastModified() {
        return this.data.getLastModified();
    }
}

