/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu.util;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.h2.jaqu.util.WeakIdentityHashMap;

public class Utils {
    private static volatile long counter;
    private static final boolean MAKE_ACCESSIBLE = true;

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <A, B> HashMap<A, B> newHashMap() {
        return new HashMap();
    }

    public static <A, B> Map<A, B> newSynchronizedHashMap() {
        HashMap<A, B> hashMap = Utils.newHashMap();
        return Collections.synchronizedMap(hashMap);
    }

    public static <A, B> WeakIdentityHashMap<A, B> newWeakIdentityHashMap() {
        return new WeakIdentityHashMap();
    }

    public static <A, B> IdentityHashMap<A, B> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <T> T newObject(Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)new Integer((int)counter++);
        }
        if (clazz == String.class) {
            return (T)("" + counter++);
        }
        if (clazz == Long.class) {
            return (T)new Long(counter++);
        }
        if (clazz == Short.class) {
            return (T)new Short((short)counter++);
        }
        if (clazz == Byte.class) {
            return (T)new Byte((byte)counter++);
        }
        if (clazz == Float.class) {
            return (T)new Float(counter++);
        }
        if (clazz == Double.class) {
            return (T)new Double(counter++);
        }
        if (clazz == Boolean.class) {
            return (T)new Boolean(false);
        }
        if (clazz == BigDecimal.class) {
            return (T)new BigDecimal(counter++);
        }
        if (clazz == BigInteger.class) {
            return (T)new BigInteger("" + counter++);
        }
        if (clazz == Date.class) {
            return (T)new Date(counter++);
        }
        if (clazz == Time.class) {
            return (T)new Time(counter++);
        }
        if (clazz == Timestamp.class) {
            return (T)new Timestamp(counter++);
        }
        if (clazz == java.util.Date.class) {
            return (T)new java.util.Date(counter++);
        }
        if (clazz == List.class) {
            return (T)new ArrayList();
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Constructor<?>[] constructorArray;
            for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                constructor.setAccessible(true);
                try {
                    return clazz.newInstance();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            for (Constructor<?> constructor : constructorArray) {
                if (constructor.getParameterTypes().length != 1) continue;
                constructor.setAccessible(true);
                try {
                    return (T)constructor.newInstance(new Object[1]);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Exception trying to create " + clazz.getName() + ": " + exception, exception);
        }
    }

    public static <T> boolean isSimpleType(Class<T> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz == String.class;
    }

    public static Object convert(Object object, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz.isAssignableFrom(clazz2)) {
            return object;
        }
        if (clazz == String.class) {
            return object.toString();
        }
        if (Number.class.isAssignableFrom(clazz2)) {
            Number number = (Number)object;
            if (clazz == Integer.class) {
                return number.intValue();
            }
            if (clazz == Long.class) {
                return number.longValue();
            }
            if (clazz == Double.class) {
                return number.doubleValue();
            }
            if (clazz == Float.class) {
                return Float.valueOf(number.floatValue());
            }
        }
        throw new RuntimeException("Can not convert the value " + object + " from " + clazz2 + " to " + clazz);
    }
}

