/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.HashSet;
import org.h2.engine.DbObject;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;

public class ExpressionVisitor {
    public static final int INDEPENDENT = 0;
    public static final int OPTIMIZABLE_MIN_MAX_COUNT_ALL = 1;
    public static final int DETERMINISTIC = 2;
    public static final int EVALUATABLE = 3;
    public static final int SET_MAX_DATA_MODIFICATION_ID = 4;
    public static final int READONLY = 5;
    public static final int NOT_FROM_RESOLVER = 6;
    public static final int GET_DEPENDENCIES = 7;
    public static final int QUERY_COMPARABLE = 8;
    private int queryLevel;
    private Table table;
    private int type;
    private long maxDataModificationId;
    private ColumnResolver resolver;
    private HashSet<DbObject> dependencies;

    private ExpressionVisitor(int n) {
        this.type = n;
    }

    public static ExpressionVisitor get(int n) {
        return new ExpressionVisitor(n);
    }

    public void addDependency(DbObject dbObject) {
        this.dependencies.add(dbObject);
    }

    public HashSet<DbObject> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(HashSet<DbObject> hashSet) {
        this.dependencies = hashSet;
    }

    public void incrementQueryLevel(int n) {
        this.queryLevel += n;
    }

    public ColumnResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ColumnResolver columnResolver) {
        this.resolver = columnResolver;
    }

    public void addDataModificationId(long l) {
        this.maxDataModificationId = Math.max(this.maxDataModificationId, l);
    }

    public long getMaxDataModificationId() {
        return this.maxDataModificationId;
    }

    int getQueryLevel() {
        return this.queryLevel;
    }

    void setQueryLevel(int n) {
        this.queryLevel = n;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public int getType() {
        return this.type;
    }
}

