/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;

public class Right
extends DbObjectBase {
    public static final int SELECT = 1;
    public static final int DELETE = 2;
    public static final int INSERT = 4;
    public static final int UPDATE = 8;
    public static final int ALL = 15;
    private Role grantedRole;
    private int grantedRight;
    private Table grantedTable;
    private RightOwner grantee;

    public Right(Database database, int n, RightOwner rightOwner, Role role) {
        this.initDbObjectBase(database, n, "RIGHT_" + n, "user");
        this.grantee = rightOwner;
        this.grantedRole = role;
    }

    public Right(Database database, int n, RightOwner rightOwner, int n2, Table table) {
        this.initDbObjectBase(database, n, "" + n, "user");
        this.grantee = rightOwner;
        this.grantedRight = n2;
        this.grantedTable = table;
    }

    private boolean appendRight(StringBuilder stringBuilder, int n, int n2, String string, boolean bl) {
        if ((n & n2) != 0) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            return true;
        }
        return bl;
    }

    public String getRights() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.grantedRight == 15) {
            stringBuilder.append("ALL");
        } else {
            boolean bl = false;
            bl = this.appendRight(stringBuilder, this.grantedRight, 1, "SELECT", bl);
            bl = this.appendRight(stringBuilder, this.grantedRight, 2, "DELETE", bl);
            bl = this.appendRight(stringBuilder, this.grantedRight, 4, "INSERT", bl);
            this.appendRight(stringBuilder, this.grantedRight, 8, "UPDATE", bl);
        }
        return stringBuilder.toString();
    }

    public Role getGrantedRole() {
        return this.grantedRole;
    }

    public Table getGrantedTable() {
        return this.grantedTable;
    }

    public DbObject getGrantee() {
        return this.grantee;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GRANT ");
        if (this.grantedRole != null) {
            stringBuilder.append(this.grantedRole.getSQL());
        } else {
            stringBuilder.append(this.getRights()).append(" ON ").append(table.getSQL());
        }
        stringBuilder.append(" TO ").append(this.grantee.getSQL());
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.grantedTable, null);
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.grantedTable != null) {
            this.grantee.revokeRight(this.grantedTable);
        } else {
            this.grantee.revokeRole(this.grantedRole);
        }
        this.database.removeMeta(session, this.getId());
        this.grantedRole = null;
        this.grantedTable = null;
        this.grantee = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        DbException.throwInternalError();
    }

    public void setRightMask(int n) {
        this.grantedRight = n;
    }

    public int getRightMask() {
        return this.grantedRight;
    }
}

