/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.wso2.carbon.server.util.FileUtils;

public class Utils {
    public static final String JAR_TO_BUNDLE_DIR = System.getProperty("java.io.tmpdir").endsWith(File.separator) ? System.getProperty("java.io.tmpdir") + "jarsToBundles" : System.getProperty("java.io.tmpdir") + File.separator + "jarsToBundles";
    private static File bundleBackupDir;

    public static File getCarbonComponentRepo() {
        String carbonComponentsRepository;
        File componentRepo;
        String carbonRepo = System.getenv("CARBON_REPOSITORY");
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.repository");
        }
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.home") + File.separator + "repository";
        }
        if (!(componentRepo = new File(carbonComponentsRepository = carbonRepo + File.separator + "components")).exists() && !componentRepo.mkdirs()) {
            System.err.println("Fail to create the directory: " + componentRepo.getAbsolutePath());
        }
        return componentRepo;
    }

    public static void printUsages() {
        String osName = System.getProperty("os.name");
        System.out.println("Usage: wso2server." + (osName.toLowerCase().indexOf("win") == -1 ? "sh" : "bat ") + " [command] [system-properties]");
        System.out.println();
        System.out.println("command:");
        System.out.println("\t--debug <port> \tStart the server in remote debugging mode.\n\t\t\tport: The remote debugging port.");
        if (osName.toLowerCase().indexOf("win") == -1) {
            System.out.println("\t--start\t\tStart Carbon using nohup in the background");
            System.out.println("\t--stop\t\tStop the Carbon server process");
            System.out.println("\t--restart\tRestart the Carbon server process");
        }
        System.out.println("\t--cleanRegistry\t\t\tClean registry space. [CAUTION] All Registry data will be lost.");
        System.out.println("\t--version\t\t\tWhat version of the product are you running?");
        System.out.println();
        System.out.println("system-properties:");
        System.out.println("\t-DhttpPort=<httpPort>\t\tOverrides the HTTP port defined in the mgt-transports.xml file");
        System.out.println("\t-DhttpsPort=<httpsPort>\t\tOverrides the HTTPS port defined in the mgt-transports.xml file");
        System.out.println("\t-DosgiConsole=[port]\t\tStart Carbon with Equinox OSGi console. \n\t\t\t\t\tIf the optional 'port' parameter is provided, a telnet port will be opened");
        System.out.println("\t-DosgiDebugOptions=[options-file]\n\t\t\t\t\tStart Carbon with OSGi debugging enabled. \n\t\t\t\t\tIf the optional 'options-file is provided, the OSGi debug options will be loaded from it.");
        System.out.println("\t-Dsetup\t\t\t\tClean the Registry & other configuration, recreate DB, re-populate the configuration, and start Carbon");
        System.out.println("\t-Dwso2.transports.xml=<transportXmlPath>\tLocation of the mgt-transports.xml file.");
        System.out.println("\t-DserverRoles=<roles>\t\tA comma separated list of roles. Used in deploying cApps");
        System.out.println("\t-Dcarbon.use.registry.repo\tUse registry based repository.");
        System.out.println("\t-DdisableHttpLog\t\tDisable HTTP access logging");
        System.out.println("\t-DapplyPatches\t\t\tUse this system property when there are patches to be applied/reverted to/from the system. ");
        System.out.println("\t\t\t\t\tDrop the patches to $CARBON_HOME/repository/componenets/patches directory and restart the system with this property. ");
        System.out.println("\t\t\t\t\tWhen you want to revert a patch, delete it from the patches directory and restart the system with this property");
        System.out.println("\t-DworkerNode\t\t\tSet this system property when starting as a worker node.");
        System.out.println("\t\t\t\t\tThis is required in clustered setups with master and worker nodes.");
        System.out.println();
    }

    public static String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(target + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = candidates[i].getName();
        }
        int result = Utils.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return candidates[result].getAbsolutePath().replace(File.separatorChar, '/') + (candidates[result].isDirectory() ? "/" : "");
    }

    static int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        for (int i = 0; i < candidates.length; ++i) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = Utils.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
                continue;
            }
            if (Utils.compareVersion(maxVersion, currentVersion) >= 0) continue;
            result = i;
            maxVersion = currentVersion;
        }
        return result;
    }

    static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    static Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{0, 0, 0, ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    public static String[] getArgs() {
        String enableOsgiDebug;
        ArrayList<String> args = new ArrayList<String>();
        String enableOsgiConsole = System.getProperty("osgiConsole");
        if (enableOsgiConsole != null && !enableOsgiConsole.toLowerCase().equals("true")) {
            try {
                enableOsgiConsole = "-console " + String.valueOf(Integer.parseInt(enableOsgiConsole));
            }
            catch (NumberFormatException ignored) {
                enableOsgiConsole = "-console";
            }
        } else if (enableOsgiConsole != null) {
            enableOsgiConsole = "-console";
        }
        if (enableOsgiConsole != null) {
            StringTokenizer tokenizer = new StringTokenizer(enableOsgiConsole, " \t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                String remainingArg;
                String arg = tokenizer.nextToken();
                if (arg.startsWith("\"")) {
                    if (arg.endsWith("\"")) {
                        if (arg.length() >= 2) {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else {
                        remainingArg = tokenizer.nextToken("\"");
                        arg = arg.substring(1) + remainingArg;
                        tokenizer.nextToken(" \t\n\r\f");
                    }
                } else if (arg.startsWith("'")) {
                    if (arg.endsWith("'")) {
                        if (arg.length() >= 2) {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else {
                        remainingArg = tokenizer.nextToken("'");
                        arg = arg.substring(1) + remainingArg;
                        tokenizer.nextToken(" \t\n\r\f");
                    }
                }
                args.add(arg);
            }
            System.out.println("OSGi console has been enabled with options: " + enableOsgiConsole);
        }
        if ((enableOsgiDebug = System.getProperty("osgiDebugOptions")) != null && enableOsgiDebug.toLowerCase().equals("true")) {
            String carbonRepo = System.getProperty("carbon.home") + File.separator + "repository";
            enableOsgiDebug = carbonRepo + File.separator + "conf" + File.separator + "osgi-debug.options";
            args.add("-debug");
            args.add(enableOsgiDebug);
            System.out.println("OSGi debugging has been enabled with options: " + enableOsgiDebug);
        }
        return args.toArray(new String[0]);
    }

    public static void applyPatches(File patchesDir, File pluginsDir) throws IOException {
        bundleBackupDir = new File(patchesDir, "patch0000");
        if (!bundleBackupDir.exists()) {
            FileUtils.copyDirectory(pluginsDir, bundleBackupDir);
        }
        Utils.copyPatches(patchesDir, pluginsDir);
    }

    private static void copyPatches(File source, File target) throws IOException {
        Object[] files = source.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            File[] patchFiles;
            if (!((File)file).isDirectory()) continue;
            if (((File)file).equals(bundleBackupDir)) {
                FileUtils.copyDirectory((File)file, target);
                continue;
            }
            for (File patch : patchFiles = ((File)file).listFiles()) {
                String patchFileName = Utils.verifyBundleFileName(patch);
                File copiedFile = new File(target, patchFileName);
                FileUtils.copyFile(patch, copiedFile, true);
            }
        }
    }

    public static File getBundleDirectory(String bundleDir) {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
        }
        if (carbonHome == null || carbonHome.length() == 0) {
            throw new RuntimeException("CARBON_HOME not found");
        }
        File dir = new File(carbonHome, bundleDir);
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.println("Fail to create the directory: " + dir.getAbsolutePath());
        }
        return dir;
    }

    public static void createBundle(File jarFile, File targetDir, Manifest mf, String extensionPrefix) throws IOException {
        if (mf == null) {
            mf = new Manifest();
        }
        String exportedPackages = Utils.parseJar(jarFile);
        String fileName = jarFile.getName();
        if ((fileName = fileName.replaceAll("-", "_")).endsWith(".jar")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        String symbolicName = extensionPrefix + fileName;
        String pluginName = extensionPrefix + fileName + "_1.0.0.jar";
        File extensionBundle = new File(targetDir, pluginName);
        Attributes attribs = mf.getMainAttributes();
        attribs.putValue("Manifest-Version", "1.0");
        attribs.putValue("Bundle-ManifestVersion", "2");
        attribs.putValue("Bundle-Name", fileName);
        attribs.putValue("Bundle-SymbolicName", symbolicName);
        attribs.putValue("Bundle-Version", "1.0.0");
        attribs.putValue("Export-Package", exportedPackages);
        attribs.putValue("Bundle-ClassPath", ".," + jarFile.getName());
        Utils.createBundle(jarFile, extensionBundle, mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBundle(File jarFile, File bundle, Manifest manifest) throws IOException {
        String extractedDirPath = JAR_TO_BUNDLE_DIR + File.separator + System.currentTimeMillis() + Math.random();
        File extractedDir = new File(extractedDirPath);
        if (!extractedDir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + extractedDir.getAbsolutePath());
        }
        FileOutputStream mfos = null;
        FileOutputStream p2InfOs = null;
        try {
            Utils.copyFileToDir(jarFile, extractedDir);
            String metaInfPath = extractedDirPath + File.separator + "META-INF";
            if (!new File(metaInfPath).mkdirs()) {
                throw new IOException("Failed to create the directory: " + metaInfPath);
            }
            mfos = new FileOutputStream(metaInfPath + File.separator + "MANIFEST.MF");
            manifest.write(mfos);
            File p2InfFile = new File(metaInfPath + File.separator + "p2.inf");
            if (!p2InfFile.createNewFile()) {
                throw new IOException("Fail to create the file: " + p2InfFile.getAbsolutePath());
            }
            p2InfOs = new FileOutputStream(p2InfFile);
            p2InfOs.write("instructions.configure=markStarted(started:true);".getBytes());
            p2InfOs.flush();
            Utils.archiveDir(bundle.getAbsolutePath(), extractedDirPath);
            Utils.deleteDir(extractedDir);
        }
        finally {
            try {
                if (mfos != null) {
                    mfos.close();
                }
            }
            catch (IOException e) {
                System.out.println("Unable to close the OutputStream " + e.getMessage());
                e.printStackTrace();
            }
            try {
                if (p2InfOs != null) {
                    p2InfOs.close();
                }
            }
            catch (IOException e) {
                System.out.println("Unable to close the OutputStream " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String aChildren : children) {
                boolean success = Utils.deleteDir(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
        return true;
    }

    public static void archiveDir(String destArchive, String sourceDir) throws IOException {
        File zipDir = new File(sourceDir);
        if (!zipDir.isDirectory()) {
            throw new RuntimeException(sourceDir + " is not a directory");
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destArchive));
        Utils.zipDir(zipDir, zos, sourceDir);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void zipDir(File zipDir, ZipOutputStream zos, String archiveSourceDir) throws IOException {
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[40960];
        int bytesIn = 0;
        for (String aDirList : dirList) {
            File f = new File(zipDir, aDirList);
            zos.putNextEntry(new ZipEntry(Utils.getZipEntryPath(f, archiveSourceDir)));
            if (f.isDirectory()) {
                Utils.zipDir(f, zos, archiveSourceDir);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    System.out.println("Unable to close the InputStream " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    protected static String getZipEntryPath(File f, String archiveSourceDir) {
        String entryPath = f.getPath();
        entryPath = entryPath.substring(archiveSourceDir.length() + 1);
        if (File.separatorChar == '\\') {
            entryPath = entryPath.replace(File.separatorChar, '/');
        }
        if (f.isDirectory()) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }

    public static void copyFileToDir(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
        }
        File file = new File(dstAbsPath + File.separator + src.getName());
        Utils.copyFile(src, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        OutputStream out = null;
        FileInputStream in = new FileInputStream(src);
        try {
            int len;
            String dstAbsPath = dst.getAbsolutePath();
            String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
            File dir = new File(dstDir);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
            }
            out = new FileOutputStream(dst);
            byte[] buf = new byte[10240];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                System.out.println("Unable to close the InputStream " + e.getMessage());
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                System.out.println("Unable to close the OutputStream " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void extract(String archive, String extractDir) throws IOException {
        FileInputStream inputStream = new FileInputStream(archive);
        Utils.extractFromStream(inputStream, extractDir);
    }

    public static void extractFromStream(InputStream inputStream, String extractDir) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            File unzipped = new File(extractDir);
            zin = new ZipInputStream(inputStream);
            if (!unzipped.mkdirs()) {
                throw new IOException("Fail to create the directory: " + unzipped.getAbsolutePath());
            }
            while ((entry = zin.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                File f = new File(extractDir + File.separator + entryName);
                if (entryName.endsWith("/") && !f.exists()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Fail to create the directory: " + f.getAbsolutePath());
                }
                int lastIndexOfSlash = entryName.lastIndexOf(47);
                String dirPath = "";
                if (lastIndexOfSlash != -1) {
                    dirPath = entryName.substring(0, lastIndexOfSlash);
                    File dir = new File(extractDir + File.separator + dirPath);
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException("Failed to create the directory: " + dir.getAbsoluteFile());
                    }
                }
                if (f.isDirectory()) continue;
                FileOutputStream out = new FileOutputStream(f);
                byte[] buf = new byte[40960];
                while ((len = zin.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            String msg = "Cannot unzip archive. It is probably corrupt";
            System.out.println(msg);
            throw e;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String parseJar(File jarFile) throws IOException {
        ArrayList<String> exportedPackagesList = new ArrayList<String>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
        List<ZipEntry> entries = Utils.populateList(zipInputStream);
        zipInputStream.close();
        for (ZipEntry entry : entries) {
            int index;
            String path = entry.getName();
            if (path.endsWith("/") || !path.endsWith(".class") || (index = path.lastIndexOf(47)) == -1) continue;
            path = path.substring(0, index);
            if (exportedPackagesList.contains(path = path.replaceAll("/", "."))) continue;
            exportedPackagesList.add(path);
        }
        String[] packageArray = exportedPackagesList.toArray(new String[exportedPackagesList.size()]);
        StringBuffer exportedPackages = new StringBuffer();
        for (int i = 0; i < packageArray.length; ++i) {
            exportedPackages.append(packageArray[i]);
            if (i == packageArray.length - 1) continue;
            exportedPackages.append(",");
        }
        return exportedPackages.toString();
    }

    private static List<ZipEntry> populateList(ZipInputStream zipInputStream) throws IOException {
        ZipEntry entry;
        ArrayList<ZipEntry> listEntry = new ArrayList<ZipEntry>();
        while (zipInputStream.available() == 1 && (entry = zipInputStream.getNextEntry()) != null) {
            listEntry.add(entry);
        }
        return listEntry;
    }

    public static void clearPrefixedSystemProperties(String prefix, Map<String, String> targetPropertyMap) {
        for (Object o : System.getProperties().keySet()) {
            String propertyName = (String)o;
            if (!propertyName.startsWith(prefix) || targetPropertyMap.containsKey(propertyName)) continue;
            targetPropertyMap.put(propertyName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String filePath) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            properties.load(fileInputStream);
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    public static String verifyBundleFileName(File file) throws IOException {
        String newFileName = file.getName();
        if (file.getName().endsWith(".jar")) {
            JarFile jar = new JarFile(file);
            Attributes attributes = jar.getManifest().getMainAttributes();
            String name = attributes.getValue("Bundle-SymbolicName");
            String version = attributes.getValue("Bundle-Version");
            if (name != null && version != null) {
                String bundleFileName = name + "_" + version + ".jar";
                if (!file.getName().equals(bundleFileName)) {
                    newFileName = bundleFileName;
                }
            }
        }
        return newFileName;
    }

    static {
        File jarsToBundlesDir = new File(JAR_TO_BUNDLE_DIR);
        if (jarsToBundlesDir.exists()) {
            Utils.deleteDir(jarsToBundlesDir);
        }
    }

    public static class JarFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar");
        }
    }
}

