/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.wso2.carbon.feature.mgt.core.ResolutionResult;
import org.wso2.carbon.feature.mgt.core.operations.OperationFactory;
import org.wso2.carbon.feature.mgt.core.operations.ProfileChangeOperation;
import org.wso2.carbon.feature.mgt.core.util.ProvisioningUtils;

public class ProvCommandProviderExt
implements CommandProvider {
    public void _provlconfigurationhistory(CommandInterpreter ci) throws Exception {
        IInstallableUnit[] uninstallableUnits;
        long timestamp;
        try {
            timestamp = Long.parseLong(ci.nextArgument());
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid timestamp.");
            return;
        }
        System.out.println("Following is a comparison of this configuration with the current configuration.");
        System.out.println("Reverting to this Configuration, would results in performing following actions on the Current Configuration.");
        System.out.println();
        ProfileChangeOperation profileChangeOperation = OperationFactory.getProfileChangeOperation("org.wso2.carbon.prov.action.revert");
        profileChangeOperation.setTimestamp(timestamp);
        ResolutionResult resolutionResult = profileChangeOperation.reviewProfileChangeAction(ProvisioningUtils.getProfile());
        IInstallableUnit[] installableUnits = resolutionResult.getReviewedInstallableUnits();
        if (installableUnits.length > 0) {
            System.out.println("Following features will be installed.");
            System.out.println("-------------------------------------");
            for (IInstallableUnit iInstallableUnit : installableUnits) {
                System.out.println(iInstallableUnit.getId() + " " + iInstallableUnit.getVersion());
            }
            System.out.println();
        }
        if ((uninstallableUnits = resolutionResult.getReviewedUninstallableUnits()).length > 0) {
            System.out.println("Following features will be uninstalled.");
            System.out.println("---------------------------------------");
            for (IInstallableUnit uninstallableUnit : uninstallableUnits) {
                System.out.println(uninstallableUnit.getId() + " " + uninstallableUnit.getVersion());
            }
        }
    }

    public String getHelp() {
        return "---Provisioning Commands Ext---\n\tprovlconfigurationhistory <timestamp> - Summary of the specified profile configuration.\n";
    }
}

