/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jgroups.util.Util;

public class RoundTripTcp {
    ServerSocket srv_sock;
    InetAddress host;
    int port = 7500;
    int num = 1000;
    int msg_size = 10;
    boolean server = false;
    final byte[] RSP_BUF = new byte[]{1};
    int num_responses = 0;

    private void start(boolean server, int num, int msg_size, InetAddress host, int port) throws IOException {
        this.server = server;
        this.num = num;
        this.msg_size = msg_size;
        this.host = host;
        this.port = port;
        if (server) {
            this.srv_sock = new ServerSocket(port, 50, host);
            System.out.println("server started (ctrl-c to kill)");
            block2: while (true) {
                Socket client_sock = this.srv_sock.accept();
                while (true) {
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        in = client_sock.getInputStream();
                        out = client_sock.getOutputStream();
                        int b = in.read();
                        out.write(this.RSP_BUF, 0, this.RSP_BUF.length);
                    }
                    catch (Exception ex) {
                        Util.close(in);
                        Util.close(out);
                        client_sock.close();
                        continue block2;
                    }
                }
                break;
            }
        }
        Socket sock = new Socket(host, port);
        System.out.println("sending " + num + " requests");
        this.sendRequests(sock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequests(Socket sock) throws IOException {
        byte[] buf = new byte[this.msg_size];
        int print = this.num / 10;
        this.num_responses = 0;
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        OutputStream out = null;
        InputStream in = null;
        try {
            out = sock.getOutputStream();
            in = sock.getInputStream();
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.num; ++i) {
                try {
                    out.write(buf, 0, buf.length);
                    int b = in.read();
                    ++this.num_responses;
                    if (this.num_responses >= this.num) {
                        System.out.println("received all responses (" + this.num_responses + ")");
                        break;
                    }
                    if (this.num_responses % print != 0) continue;
                    System.out.println("- received " + this.num_responses);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            long stop = System.currentTimeMillis();
            long total = stop - start;
            double requests_per_sec = (double)this.num / ((double)total / 1000.0);
            double ms_per_req = (double)total / (double)this.num;
            System.out.println("Took " + total + "ms for " + this.num + " requests: " + requests_per_sec + " requests/sec, " + ms_per_req + " ms/request");
        }
        catch (Throwable throwable) {
            Util.close(in);
            Util.close(out);
            sock.close();
            throw throwable;
        }
        Util.close(in);
        Util.close(out);
        sock.close();
    }

    public static void main(String[] args) throws IOException {
        boolean server = false;
        int num = 100;
        int msg_size = 10;
        InetAddress host = null;
        int port = 7500;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-server")) {
                server = true;
                continue;
            }
            if (args[i].equals("-size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-host")) {
                host = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            RoundTripTcp.help();
            return;
        }
        if (host == null) {
            host = InetAddress.getLocalHost();
        }
        new RoundTripTcp().start(server, num, msg_size, host, port);
    }

    private static void help() {
        System.out.println("RoundTrip [-server] [-num <number of messages>] [-size <size of each message (in bytes)>] [-host <host>] [-port <port>]");
    }
}

