/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CarbonUIMessage
implements Serializable {
    private static final long serialVersionUID = 7464385412679479148L;
    public static final String ID = "carbonUIMessage";
    public static final String INFO = "info";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    private String message;
    private String messageType;
    private Exception exception;
    private boolean showStackTrace = true;

    public CarbonUIMessage(String message, String messageType) {
        this.message = message;
        this.messageType = messageType;
    }

    public CarbonUIMessage(String message, String messageType, Exception exception) {
        this.message = message;
        this.messageType = messageType;
        this.exception = exception;
    }

    public CarbonUIMessage(String message, String messageType, Exception exception, boolean showStackTrace) {
        this.message = message;
        this.messageType = messageType;
        this.exception = exception;
        this.showStackTrace = showStackTrace;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public static void sendCarbonUIMessage(String message, String messageType, HttpServletRequest request, HttpServletResponse response, String urlToRedirect) throws IOException {
        CarbonUIMessage carbonMessage = new CarbonUIMessage(message, messageType);
        request.getSession().setAttribute(ID, (Object)carbonMessage);
        response.sendRedirect(urlToRedirect);
    }

    public static CarbonUIMessage sendCarbonUIMessage(String message, String messageType, HttpServletRequest request, HttpServletResponse response, String urlToRedirect, Exception exception) throws IOException {
        CarbonUIMessage carbonMessage = new CarbonUIMessage(message, messageType, exception);
        request.getSession().setAttribute(ID, (Object)carbonMessage);
        response.sendRedirect(urlToRedirect);
        return carbonMessage;
    }

    public static void sendCarbonUIMessage(String message, String messageType, HttpServletRequest request) {
        CarbonUIMessage carbonMessage = new CarbonUIMessage(message, messageType);
        request.getSession().setAttribute(ID, (Object)carbonMessage);
    }

    public static void sendCarbonUIMessage(String message, String messageType, HttpServletRequest request, Exception exception) {
        CarbonUIMessage carbonMessage = new CarbonUIMessage(message, messageType, exception);
        request.getSession().setAttribute(ID, (Object)carbonMessage);
    }
}

