/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

public class SecurityContextTokenProcessor
implements Processor {
    private String sctId;
    private byte[] secret;
    private String identifier;

    @Override
    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        SecurityContextToken sct = new SecurityContextToken(elem);
        this.identifier = sct.getIdentifier();
        this.secret = this.getSecret(cb, sct);
        this.sctId = sct.getID();
        returnResults.add(0, new WSSecurityEngineResult(1024, sct));
    }

    private byte[] getSecret(CallbackHandler cb, SecurityContextToken sct) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback callback = new WSPasswordCallback(sct.getIdentifier(), 6);
        try {
            Callback[] callbacks = new Callback[]{callback};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{sct.getIdentifier()}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{sct.getIdentifier()}, e);
        }
        return callback.getKey();
    }

    @Override
    public String getId() {
        return this.sctId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public byte[] getSecret() {
        return this.secret;
    }
}

