/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

public class BinarySecurityTokenProcessor
implements Processor {
    private String id;
    private String type;
    private X509Certificate[] certificates;
    private BinarySecurity token;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        if (crypto == null) {
            this.getCertificatesTokenReference(elem, decCrypto);
        } else {
            this.getCertificatesTokenReference(elem, crypto);
        }
        returnResults.add(0, new WSSecurityEngineResult(4096, this.token, this.certificates));
        this.id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    private void getCertificatesTokenReference(Element elem, Crypto crypto) throws WSSecurityException {
        this.createSecurityToken(elem);
        if (this.token instanceof PKIPathSecurity) {
            this.certificates = ((PKIPathSecurity)this.token).getX509Certificates(false, crypto);
        } else if (this.token instanceof X509Security) {
            X509Certificate cert = ((X509Security)this.token).getX509Certificate(crypto);
            this.certificates = new X509Certificate[1];
            this.certificates[0] = cert;
        }
    }

    private void createSecurityToken(Element element) throws WSSecurityException {
        this.token = new BinarySecurity(element);
        this.type = this.token.getValueType();
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(this.type)) {
            this.token = new X509Security(element);
        } else if (PKIPathSecurity.getType().equals(this.type)) {
            this.token = new PKIPathSecurity(element);
        }
    }

    public String getType() {
        return this.type;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public BinarySecurity getToken() {
        return this.token;
    }
}

