/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.PrivilegedAction;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.kerberos.KrbSession;
import org.apache.ws.security.kerberos.KrbSessionCache;
import org.apache.ws.security.message.CredentialsCallbackHandler;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.SecurityUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecKerberosToken
extends WSSecSignature {
    private static Log log = LogFactory.getLog(WSSecKerberosToken.class);
    public static final String KERBEROS_SERVICE_PRINCIPLE_UNKNOWN = "servicePrincipalUnknown";
    protected String tokenUri;
    protected Subject subject;
    private CredentialsCallbackHandler credHandler;
    private String servicePrincipalName = "servicePrincipalUnknown";
    protected WSSecHeader wsSecHeader;
    private SecretKey sessionKey;
    private KrbSession krbSession;
    private boolean receiver = false;

    public KrbSession getKrbSession() {
        return this.krbSession;
    }

    public void setKrbSession(KrbSession krbSession) {
        this.krbSession = krbSession;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.secRef;
    }

    public SecretKey getSessionKey() {
        return this.sessionKey;
    }

    public void setBSTToken(BinarySecurity bstToken) {
        this.bstToken = bstToken;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public Document build(Document doc, WSSecHeader secHeader) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning kerberos token processing...");
        }
        this.credHandler = new CredentialsCallbackHandler(this.user, this.password);
        this.document = doc;
        this.wsSecHeader = secHeader;
        this.prepare();
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        return this.document;
    }

    private KerberosTicket getTicketGrantingTicket() throws LoginException {
        LoginContext loginContext = new LoginContext("Client", this.credHandler);
        loginContext.login();
        this.subject = loginContext.getSubject();
        KerberosTicket ticket = this.subject.getPrivateCredentials(KerberosTicket.class).iterator().next();
        return ticket;
    }

    private byte[] getServiceTicketData(final String servicePrincipalName) throws GSSException {
        byte[] serviceTicket = null;
        serviceTicket = Subject.doAs(this.subject, new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                    Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
                    GSSName serverName = manager.createName(servicePrincipalName, krb5PrincipalNameType);
                    GSSContext context = manager.createContext(serverName, krb5Oid, null, 0);
                    byte[] token = new byte[]{};
                    context.requestMutualAuth(false);
                    context.requestCredDeleg(false);
                    return context.initSecContext(token, 0, token.length);
                }
                catch (GSSException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return serviceTicket;
    }

    private SecretKey getSessionKey(KerberosTicket tgt) throws WSSecurityException {
        for (Object cred : this.subject.getPrivateCredentials()) {
            if (!(cred instanceof KerberosTicket) || cred.equals(tgt)) continue;
            KerberosTicket ticket = (KerberosTicket)cred;
            return ticket.getSessionKey();
        }
        throw new WSSecurityException("Could not find service ticket with server principal name " + this.servicePrincipalName);
    }

    public boolean isReceiver() {
        return this.receiver;
    }

    public void setReceiver(boolean receiver) {
        this.receiver = receiver;
    }

    private void prepare() throws WSSecurityException {
        boolean needSession = false;
        KrbSession krbSession = null;
        krbSession = KrbSessionCache.getInstance().getCurrentSession();
        if (krbSession == null) {
            needSession = true;
        }
        this.secRef = new SecurityTokenReference(this.document);
        this.strUri = "STRId-" + this.secRef.hashCode();
        this.secRef.setID(this.strUri);
        byte[] tokenData = null;
        if (needSession) {
            try {
                KerberosTicket tgt = this.getTicketGrantingTicket();
                tokenData = this.getServiceTicketData(this.servicePrincipalName);
                this.sessionKey = this.getSessionKey(tgt);
                krbSession = new KrbSession(SecurityUtil.getSHA1(tokenData), this.sessionKey);
                krbSession.setClientPrincipalName(this.user);
                krbSession.setServerPrincipalName(this.servicePrincipalName);
                KrbSessionCache.getInstance().addSession(krbSession);
            }
            catch (LoginException e) {
                throw new WSSecurityException(5, "kerberosLoginFailed", new Object[]{e.getMessage()});
            }
            catch (GSSException e) {
                throw new WSSecurityException(5, "kerberosSTReqFailed", new Object[]{this.servicePrincipalName, e.getMessage()});
            }
            catch (Exception e) {
                throw new WSSecurityException(5, "kerberosSTReqFailed", new Object[]{this.servicePrincipalName, e.getMessage()});
            }
            if (tokenData == null) {
                throw new WSSecurityException(5, "kerberosSTReqFailed", new Object[]{this.servicePrincipalName, "Check service principal exists in KDC"});
            }
            this.tokenUri = "KerbTokenId-" + tokenData.hashCode();
        } else {
            this.keyIdentifierType = 8;
        }
        this.wsDocInfo = new WSDocInfo(this.document);
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(this.document);
                ref.setURI("#" + this.tokenUri);
                this.bstToken = new KerberosSecurity(this.document);
                ((KerberosSecurity)this.bstToken).setKerberosToken(tokenData);
                ref.setValueType(this.bstToken.getValueType());
                this.secRef.setReference(ref);
                this.bstToken.setID(this.tokenUri);
                this.wsDocInfo.setBst(this.bstToken.getElement());
                break;
            }
            case 8: {
                this.secRef.setKerberosIdentifierThumb(krbSession);
                this.sessionKey = krbSession.getSessionKey();
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
    }

    public void signMessage() throws WSSecurityException {
        if (this.sigAlgo == null) {
            this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }
        if (this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Element canonElem = XMLUtils.createElementInSignatureSpace(this.document, "CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", this.canonAlgo);
            if (this.wssConfig.isWsiBSPCompliant()) {
                Set prefixes = this.getInclusivePrefixes(this.wsSecHeader.getSecurityHeader(), false);
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(this.document, prefixes);
                canonElem.appendChild(inclusiveNamespaces.getElement());
            }
            try {
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(this.document, this.sigAlgo);
                this.sig = new XMLSignature(this.document, null, signatureAlgorithm.getElement(), canonElem);
            }
            catch (XMLSecurityException e) {
                log.error((Object)"", (Throwable)e);
                throw new WSSecurityException(9, "noXMLSig");
            }
        }
        try {
            this.sig = new XMLSignature(this.document, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new WSSecurityException(9, "noXMLSig");
        }
        this.sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        String sigUri = "Signature-" + this.sig.hashCode();
        this.sig.setId(sigUri);
        this.keyInfo = this.sig.getKeyInfo();
        this.keyInfoUri = "KeyId-" + this.keyInfo.hashCode();
        this.keyInfo.setId(this.keyInfoUri);
        this.keyInfo.addUnknownElement(this.secRef.getElement());
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.document.getDocumentElement());
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        this.addReferencesToSign(this.parts, this.wsSecHeader);
        this.computeSignature();
    }

    @Override
    public void computeSignature() throws WSSecurityException {
        WSDocInfoStore.store(this.wsDocInfo);
        try {
            this.sig.sign(this.sessionKey);
            this.signatureValue = this.sig.getSignatureValue();
        }
        catch (Exception e) {
            throw new WSSecurityException(9, null, null, e);
        }
        finally {
            WSDocInfoStore.delete(this.wsDocInfo);
        }
    }

    @Override
    public void prependBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), this.bstToken.getElement(), false);
        }
    }
}

