/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.kerberos;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.kerberos.KrbSession;

public class KrbSessionCache {
    private ThreadLocal<Stack<KrbSession>> threadLocal = new ThreadLocal();
    private Map<String, KrbSession> kerbSessionsByThumbprint = new ConcurrentHashMap<String, KrbSession>();
    private static KrbSessionCache instance = new KrbSessionCache();
    private static Log log = LogFactory.getLog((String)KrbSessionCache.class.getName());

    private KrbSessionCache() {
    }

    public static KrbSessionCache getInstance() {
        return instance;
    }

    private Stack<KrbSession> getLocalSession() {
        if (this.threadLocal.get() == null) {
            this.threadLocal.set(new Stack());
        }
        return this.threadLocal.get();
    }

    public void addSession(KrbSession session) {
        Stack<KrbSession> localSession = this.getLocalSession();
        this.kerbSessionsByThumbprint.put(session.getThumbPrintEncoded(), session);
        if (!localSession.contains(session)) {
            localSession.push(session);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session added : " + session.getThumbPrintEncoded()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Session already exists : " + session.getThumbPrintEncoded()));
        }
    }

    public KrbSession getSession(String thumbPrintEncoded) {
        KrbSession result = this.kerbSessionsByThumbprint.get(thumbPrintEncoded);
        if (result != null) {
            this.kerbSessionsByThumbprint.remove(thumbPrintEncoded);
        }
        return result;
    }

    public KrbSession getCurrentSession() {
        Stack<KrbSession> localSession = this.getLocalSession();
        if (localSession != null && !localSession.isEmpty()) {
            return localSession.pop();
        }
        return null;
    }

    public void setCurrentSession(KrbSession kerberosSession) {
        Stack<KrbSession> localSession = this.getLocalSession();
        if (!localSession.contains(kerberosSession)) {
            localSession.push(kerberosSession);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session added : " + kerberosSession.getThumbPrintEncoded()));
            }
        }
    }
}

