/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AbstractCrypto;
import org.apache.ws.security.components.crypto.CredentialException;

public class BouncyCastle
extends AbstractCrypto {
    public BouncyCastle(Properties properties) throws CredentialException, IOException {
        super(properties);
    }

    public BouncyCastle(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        super(properties, loader);
    }

    @Override
    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertPath path = null;
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            path = factory.generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    @Override
    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        Vector<X509Certificate> list = new Vector<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.add(0, certs[i]);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            CertPath path = factory.generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
    }

    @Override
    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        try {
            List<X509Certificate> certList = Arrays.asList(certs);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            CertPath path = factory.generateCertPath(certList);
            PKIXParameters param = new PKIXParameters(this.keystore);
            param.setRevocationEnabled(false);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            certPathValidator.validate(path, param);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (CertificateException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (CertPathValidatorException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        return true;
    }
}

