/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WsuIdAllocator;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.action.EncryptionAction;
import org.apache.ws.security.action.SignatureAction;
import org.apache.ws.security.action.SignatureConfirmationAction;
import org.apache.ws.security.action.TimestampAction;
import org.apache.ws.security.action.UsernameTokenAction;
import org.apache.ws.security.action.UsernameTokenSignedAction;
import org.apache.ws.security.processor.BinarySecurityTokenProcessor;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedDataProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.SAML2TokenProcessor;
import org.apache.ws.security.processor.SecurityContextTokenProcessor;
import org.apache.ws.security.processor.SignatureConfirmationProcessor;
import org.apache.ws.security.processor.SignatureProcessor;
import org.apache.ws.security.processor.TimestampProcessor;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.UUIDGenerator;
import org.apache.xml.security.Init;
import org.apache.xml.security.transforms.Transform;

public class WSSConfig {
    private static final Log log;
    private static final Map DEFAULT_ACTIONS;
    private static final Map DEFAULT_PROCESSORS;
    protected static WSSConfig defaultConfig;
    protected boolean wsiBSPCompliant = false;
    protected boolean precisionInMilliSeconds = true;
    protected boolean enableSignatureConfirmation = true;
    protected boolean timeStampStrict = true;
    protected boolean handleCustomPasswordTypes = false;
    protected boolean allowNamespaceQualifiedPasswordTypes = false;
    protected int secretKeyLength = 16;
    protected boolean passwordsAreEncoded = false;
    public static WsuIdAllocator DEFAULT_ID_ALLOCATOR;
    protected WsuIdAllocator idAllocator = DEFAULT_ID_ALLOCATOR;
    protected HashMap jceProvider = new HashMap(10);
    private final Map actionMap = new HashMap(DEFAULT_ACTIONS);
    private final Map processorMap = new HashMap(DEFAULT_PROCESSORS);
    private static boolean addJceProviders;
    private static boolean staticallyInitialized;

    public static void setAddJceProviders(boolean value) {
        addJceProviders = value;
    }

    private synchronized void staticInit() {
        if (!staticallyInitialized) {
            block4: {
                Init.init();
                if (addJceProviders) {
                    this.addJceProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
                    this.addJceProvider("JuiCE", "org.apache.security.juice.provider.JuiCEProviderOpenSSL");
                }
                try {
                    Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "org.apache.ws.security.transform.STRTransform");
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            staticallyInitialized = true;
        }
    }

    protected WSSConfig() {
        this.staticInit();
    }

    public static WSSConfig getNewInstance() {
        return new WSSConfig();
    }

    public static WSSConfig getDefaultWSConfig() {
        if (defaultConfig == null) {
            defaultConfig = WSSConfig.getNewInstance();
        }
        return defaultConfig;
    }

    public boolean isWsiBSPCompliant() {
        return this.wsiBSPCompliant;
    }

    public void setWsiBSPCompliant(boolean wsiBSPCompliant) {
        this.wsiBSPCompliant = wsiBSPCompliant;
    }

    public boolean isPrecisionInMilliSeconds() {
        return this.precisionInMilliSeconds;
    }

    public void setPrecisionInMilliSeconds(boolean precisionInMilliSeconds) {
        this.precisionInMilliSeconds = precisionInMilliSeconds;
    }

    public boolean isEnableSignatureConfirmation() {
        return this.enableSignatureConfirmation;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public void setHandleCustomPasswordTypes(boolean handleCustomTypes) {
        this.handleCustomPasswordTypes = handleCustomTypes;
    }

    public boolean getHandleCustomPasswordTypes() {
        return this.handleCustomPasswordTypes;
    }

    public void setAllowNamespaceQualifiedPasswordTypes(boolean allowNamespaceQualifiedTypes) {
        this.allowNamespaceQualifiedPasswordTypes = allowNamespaceQualifiedTypes;
    }

    public boolean getAllowNamespaceQualifiedPasswordTypes() {
        return this.allowNamespaceQualifiedPasswordTypes;
    }

    public boolean isTimeStampStrict() {
        return this.timeStampStrict;
    }

    public void setTimeStampStrict(boolean timeStampStrict) {
        this.timeStampStrict = timeStampStrict;
    }

    public void setSecretKeyLength(int length) {
        this.secretKeyLength = length;
    }

    public int getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public WsuIdAllocator getIdAllocator() {
        return this.idAllocator;
    }

    public void setIdAllocator(WsuIdAllocator idAllocator) {
        this.idAllocator = idAllocator;
    }

    public String setAction(int code, String action) {
        String previousAction = this.actionMap.put(new Integer(code), action);
        if (previousAction instanceof String) {
            return previousAction;
        }
        if (previousAction instanceof Action) {
            return previousAction.getClass().getName();
        }
        return null;
    }

    public String setAction(int code, Action action) {
        Action previousAction = this.actionMap.put(new Integer(code), action);
        if (previousAction instanceof String) {
            return (String)((Object)previousAction);
        }
        if (previousAction instanceof Action) {
            return previousAction.getClass().getName();
        }
        return null;
    }

    public Action getAction(int action) throws WSSecurityException {
        Integer key = new Integer(action);
        Object actionObject = this.actionMap.get(key);
        if (actionObject instanceof String) {
            String name = (String)actionObject;
            try {
                return (Action)Loader.loadClass(name).newInstance();
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)t.getMessage(), t);
                }
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name}, t);
            }
        }
        if (actionObject instanceof Action) {
            return (Action)actionObject;
        }
        return null;
    }

    public String setProcessor(QName el, String name) {
        String previousProcessor = this.processorMap.put(el, name);
        if (previousProcessor instanceof String) {
            return previousProcessor;
        }
        if (previousProcessor instanceof Processor) {
            return previousProcessor.getClass().getName();
        }
        return null;
    }

    public String setProcessor(QName el, Processor processor) {
        Processor previousProcessor = this.processorMap.put(el, processor);
        if (previousProcessor instanceof String) {
            return (String)((Object)previousProcessor);
        }
        if (previousProcessor instanceof Processor) {
            return previousProcessor.getClass().getName();
        }
        return null;
    }

    public Processor getProcessor(QName el) throws WSSecurityException {
        Object processorObject = this.processorMap.get(el);
        if (processorObject instanceof String) {
            String name = (String)processorObject;
            try {
                return (Processor)Loader.loadClass(name).newInstance();
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)t.getMessage(), t);
                }
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name}, t);
            }
        }
        if (processorObject instanceof Processor) {
            return (Processor)processorObject;
        }
        return null;
    }

    private boolean loadProvider(String id, String className) {
        try {
            if (Security.getProvider(id) == null) {
                Class c = Loader.loadClass(className, false);
                Provider[] provs = Security.getProviders();
                int ret = 0;
                for (int i = 0; i < provs.length; ++i) {
                    if (!"SUN".equals(provs[i].getName()) && !"IBMJCE".equals(provs[i].getName())) continue;
                    ret = Security.insertProviderAt((Provider)c.newInstance(), i + 2);
                    break;
                }
                if (ret == 0) {
                    ret = Security.insertProviderAt((Provider)c.newInstance(), 2);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The provider " + id + " was added at position: " + ret));
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The provider " + id + " could not be added: " + t.getMessage()));
            }
            return false;
        }
    }

    public boolean addJceProvider(String id, String className) {
        if (this.jceProvider.get(id) == null && this.loadProvider(id, className)) {
            this.jceProvider.put(id, className);
            return true;
        }
        return false;
    }

    static {
        HashMap<Serializable, String> tmp;
        block5: {
            block4: {
                log = LogFactory.getLog((String)WSSConfig.class.getName());
                tmp = new HashMap<Serializable, String>();
                try {
                    tmp.put(new Integer(1), UsernameTokenAction.class.getName());
                    tmp.put(new Integer(4), EncryptionAction.class.getName());
                    tmp.put(new Integer(2), SignatureAction.class.getName());
                    tmp.put(new Integer(16), "org.apache.ws.security.action.SAMLTokenSignedAction");
                    tmp.put(new Integer(8), "org.apache.ws.security.action.SAMLTokenUnsignedAction");
                    tmp.put(new Integer(32), TimestampAction.class.getName());
                    tmp.put(new Integer(64), UsernameTokenSignedAction.class.getName());
                    tmp.put(new Integer(128), SignatureConfirmationAction.class.getName());
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)t.getMessage(), t);
                }
            }
            DEFAULT_ACTIONS = Collections.unmodifiableMap(tmp);
            tmp = new HashMap();
            try {
                tmp.put(WSSecurityEngine.SAML_TOKEN, "org.apache.ws.security.processor.SAMLTokenProcessor");
                tmp.put(WSSecurityEngine.ENCRYPTED_KEY, EncryptedKeyProcessor.class.getName());
                tmp.put(WSSecurityEngine.SIGNATURE, SignatureProcessor.class.getName());
                tmp.put(WSSecurityEngine.timeStamp, TimestampProcessor.class.getName());
                tmp.put(WSSecurityEngine.usernameToken, UsernameTokenProcessor.class.getName());
                tmp.put(WSSecurityEngine.REFERENCE_LIST, ReferenceListProcessor.class.getName());
                tmp.put(WSSecurityEngine.signatureConfirmation, SignatureConfirmationProcessor.class.getName());
                tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02, DerivedKeyTokenProcessor.class.getName());
                tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_12, (String)tmp.get(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02));
                tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02, SecurityContextTokenProcessor.class.getName());
                tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12, (String)tmp.get(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02));
                tmp.put(WSSecurityEngine.binaryToken, BinarySecurityTokenProcessor.class.getName());
                tmp.put(WSSecurityEngine.ENCRYPTED_DATA, EncryptedDataProcessor.class.getName());
                tmp.put(WSSecurityEngine.SAML2_TOKEN, SAML2TokenProcessor.class.getName());
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)t.getMessage(), t);
            }
        }
        DEFAULT_PROCESSORS = Collections.unmodifiableMap(tmp);
        defaultConfig = null;
        DEFAULT_ID_ALLOCATOR = new WsuIdAllocator(){
            int i;

            private synchronized String next() {
                return Integer.toString(++this.i);
            }

            @Override
            public String createId(String prefix, Object o) {
                if (prefix == null) {
                    return this.next();
                }
                return prefix + this.next();
            }

            @Override
            public String createSecureId(String prefix, Object o) {
                if (prefix == null) {
                    return UUIDGenerator.getUUID();
                }
                return prefix + UUIDGenerator.getUUID();
            }
        };
        addJceProviders = true;
        staticallyInitialized = false;
    }
}

