/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.init;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.core.init.CarbonServerManager;

public class OSGiAxis2ServicesListener
implements BundleListener {
    private BundleContext bundleContext;
    private CarbonServerManager carbonServerManager;
    private boolean listenerRegistered;
    private Map<String, Bundle> osgiAxis2Services = new HashMap<String, Bundle>();

    public OSGiAxis2ServicesListener(BundleContext bundleContext, CarbonServerManager carbonServerManager) {
        this.bundleContext = bundleContext;
        this.carbonServerManager = carbonServerManager;
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void addOSGiAxis2Service(Bundle bundle) {
        this.osgiAxis2Services.put(this.getKey(bundle), bundle);
    }

    private String getKey(Bundle bundle) {
        return bundle.getSymbolicName() + "-" + bundle.getVersion();
    }

    boolean registerBundleListener() {
        if (this.osgiAxis2Services.isEmpty() && this.osgiAxis2Services.isEmpty()) {
            this.listenerRegistered = false;
        } else {
            this.bundleContext.addBundleListener((BundleListener)this);
            this.listenerRegistered = true;
        }
        return this.listenerRegistered;
    }

    void unregisterBundleListener() {
        if (this.listenerRegistered) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
    }

    synchronized void start() {
        for (Bundle bundle : this.osgiAxis2Services.values()) {
            if (bundle.getState() == 32) continue;
            this.carbonServerManager.addPendingItem(this.getKey(bundle), "OSGiAxis2Service");
        }
    }

    public synchronized void bundleChanged(BundleEvent event) {
        String key = this.getKey(event.getBundle());
        if (event.getType() != 16 && event.getType() != 2) {
            return;
        }
        if (this.osgiAxis2Services.containsKey(key)) {
            this.carbonServerManager.removePendingItem(key);
        }
    }
}

