/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.caching;

import java.io.Serializable;
import java.util.Set;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.authorization.AuthorizationKey;
import org.wso2.carbon.caching.core.identity.IdentityCacheKey;
import org.wso2.carbon.caching.core.rolesofuser.UserRolesCacheKey;

public class InvalidateCacheEntryMessage
extends ClusteringMessage {
    private static final long serialVersionUID = 5223440009631274037L;
    private static Log log = LogFactory.getLog(InvalidateCacheEntryMessage.class);
    private String cacheName;
    private Serializable key;

    public InvalidateCacheEntryMessage() {
    }

    public InvalidateCacheEntryMessage(String cacheName, Serializable key) {
        this.cacheName = cacheName;
        this.key = key;
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        if (this.cacheName != null && this.key != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got cluster message " + this.cacheName + ":" + this.key.toString()));
            }
            Cache cache = CacheManager.getInstance().getCache(this.cacheName);
            if (this.key instanceof Integer) {
                if (cache != null) {
                    Set cacheKeySet = cache.keySet();
                    for (Object cacheKey : cacheKeySet) {
                        if (cacheKey instanceof AuthorizationKey) {
                            AuthorizationKey authorizationKey = (AuthorizationKey)cacheKey;
                            if (((Integer)this.key).intValue() != authorizationKey.getTenantId()) continue;
                            cache.remove((Object)authorizationKey);
                            continue;
                        }
                        if (cacheKey instanceof UserRolesCacheKey) {
                            UserRolesCacheKey userRolesCacheKey = (UserRolesCacheKey)cacheKey;
                            if (((Integer)this.key).intValue() != userRolesCacheKey.getTenantId()) continue;
                            cache.remove((Object)userRolesCacheKey);
                            continue;
                        }
                        if (!(cacheKey instanceof IdentityCacheKey)) continue;
                        IdentityCacheKey identityCacheKey = (IdentityCacheKey)cacheKey;
                        if (((Integer)this.key).intValue() != identityCacheKey.getTenantId()) continue;
                        cache.remove((Object)identityCacheKey);
                    }
                }
            } else if (cache.containsKey((Object)this.key)) {
                cache.remove((Object)this.key);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Got cluster message " + this.cacheName + ":" + this.key.toString()));
        }
    }
}

