/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.privilegedaction;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.admin.internal.PrivilegedActionServiceComponent;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedAction;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedActionConfiguration;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedActionConfigurationXMLProcessor;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedActionException;

public class PrivilegedActionMessageReceiver
extends RPCMessageReceiver {
    private static final Log log = LogFactory.getLog(PrivilegedActionMessageReceiver.class);
    private static boolean SKIP_SERVICE_INVOCATION = false;
    private static boolean SKIP_LOWER_PRIORITY_EXTENSIONS = false;

    public PrivilegedActionMessageReceiver() throws PrivilegedActionException {
        PrivilegedActionConfiguration privilegedActionConfiguration = PrivilegedActionConfigurationXMLProcessor.buildPrivilegedActionConfigurationFromFile();
        SKIP_SERVICE_INVOCATION = privilegedActionConfiguration.isSkipServiceInvocation();
        SKIP_LOWER_PRIORITY_EXTENSIONS = privilegedActionConfiguration.isSkipLowerPriorityExtensions();
    }

    public void invokeBusinessLogic(MessageContext inMsgCtx, MessageContext outMsgCtx) throws AxisFault {
        boolean skipLowerPriorityExtensions = false;
        boolean skipServiceInvocation = false;
        int skipPriority = -1;
        List<PrivilegedAction> extensions = this.getPrivilegedActionExtensions(inMsgCtx);
        for (PrivilegedAction ext : extensions) {
            if (skipLowerPriorityExtensions && ext.getPriority() != skipPriority) continue;
            try {
                ext.execute(inMsgCtx, outMsgCtx);
                if (SKIP_LOWER_PRIORITY_EXTENSIONS && ext.skipLowerPriorityExtensions()) {
                    skipLowerPriorityExtensions = true;
                    skipPriority = ext.getPriority();
                }
                if (!SKIP_SERVICE_INVOCATION || !ext.skipServiceInvocation()) continue;
                skipServiceInvocation = true;
            }
            catch (PrivilegedActionException e) {
                log.error((Object)("Error while executing the privileged action extension " + ext.getExtensionName()), (Throwable)e);
                throw new AxisFault("Error while executing the privileged action extension " + ext.getExtensionName(), (Throwable)e);
            }
        }
        if (!skipServiceInvocation) {
            super.invokeBusinessLogic(inMsgCtx, outMsgCtx);
        }
    }

    private List<PrivilegedAction> getPrivilegedActionExtensions(MessageContext messageContext) {
        ArrayList<PrivilegedAction> returnList = new ArrayList<PrivilegedAction>();
        for (PrivilegedAction privilegedAction : PrivilegedActionServiceComponent.privilegedActions) {
            if (privilegedAction.isDisabled() || !privilegedAction.doesHandle(messageContext)) continue;
            returnList.add(privilegedAction);
        }
        return returnList;
    }
}

