/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.privilegedaction;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedActionConfiguration;
import org.wso2.carbon.server.admin.privilegedaction.PrivilegedActionException;

public class PrivilegedActionConfigurationXMLProcessor {
    private static final Log log = LogFactory.getLog(PrivilegedActionConfigurationXMLProcessor.class);
    public static final String PRIVILEGED_ACTION_CONFIG_FILE = "privilegedaction.xml";
    public static final String LOCAL_NAME_PRIVILEGED_ACTION = "privilegedaction";
    public static final String LOCAL_NAME_SKIP_SERVICE_INVOCATION = "skipServiceInvocation";
    public static final String LOCAL_NAME_SKIP_LOWER_PRIORITY_EXTENSIONS = "skipLowerPriorityExtensions";

    public static PrivilegedActionConfiguration buildPrivilegedActionConfigurationFromFile() throws PrivilegedActionException {
        OMElement privilegedActionElement = PrivilegedActionConfigurationXMLProcessor.getPrivilegedActionElement();
        PrivilegedActionConfiguration privilegedActionConfig = PrivilegedActionConfigurationXMLProcessor.buildPrivilegedActionConfiguration(privilegedActionElement);
        return privilegedActionConfig;
    }

    private static PrivilegedActionConfiguration buildPrivilegedActionConfiguration(OMElement privilegedActionElement) {
        boolean skipServiceInvocation = Boolean.parseBoolean(privilegedActionElement.getFirstChildWithName(new QName(LOCAL_NAME_SKIP_SERVICE_INVOCATION)).getText());
        boolean skipLowerPriorityExtensions = Boolean.parseBoolean(privilegedActionElement.getFirstChildWithName(new QName(LOCAL_NAME_SKIP_LOWER_PRIORITY_EXTENSIONS)).getText());
        PrivilegedActionConfiguration privilegedActionConfig = new PrivilegedActionConfiguration();
        privilegedActionConfig.setSkipServiceInvocation(skipServiceInvocation);
        privilegedActionConfig.setSkipLowerPriorityExtensions(skipLowerPriorityExtensions);
        return privilegedActionConfig;
    }

    private static OMElement getPrivilegedActionElement() throws PrivilegedActionException {
        InputStream inStream = PrivilegedActionConfigurationXMLProcessor.class.getResourceAsStream("/privilegedaction.xml");
        if (inStream == null) {
            throw new PrivilegedActionException("Unable to find PrivilegedAction configuration file privilegedaction.xml");
        }
        OMElement privilegedActionElement = null;
        try {
            String confString = PrivilegedActionConfigurationXMLProcessor.convertStreamToString(inStream);
            privilegedActionElement = PrivilegedActionConfigurationXMLProcessor.createOMElement(confString);
            inStream.close();
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while closing InputStream of privilegedaction.xml", (Throwable)e);
        }
        return privilegedActionElement;
    }

    private static String convertStreamToString(InputStream is) {
        try {
            return new Scanner(is).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    private static OMElement createOMElement(String string) throws PrivilegedActionException {
        int start = string.indexOf("<privilegedaction");
        int end = string.lastIndexOf("privilegedaction>") + LOCAL_NAME_PRIVILEGED_ACTION.length() + 1;
        String stringWithoutComments = string.substring(start, end);
        String trimmedString = stringWithoutComments.replaceAll("[\\n\\s]", "");
        try {
            return AXIOMUtil.stringToOM((String)trimmedString);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unable to parse privilegedaction.xml", (Throwable)e);
            throw new PrivilegedActionException("Unable to parse privilegedaction.xml");
        }
    }
}

