/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.auth;

import java.util.Arrays;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.services.authentication.BackendAuthenticator;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.core.services.authentication.ServerAuthenticator;
import org.wso2.carbon.server.admin.auth.AuthenticatorComparator;

public class AuthenticatorServerRegistry {
    private static Log log = LogFactory.getLog(AuthenticatorServerRegistry.class);
    @Deprecated
    private static ServiceTracker authTracker;
    private static ServiceTracker defaultAuthTracker;
    public static final String AUTHENTICATOR_TYPE = "authenticator.type";

    public static void init(BundleContext bc) throws Exception {
        try {
            authTracker = new ServiceTracker(bc, CarbonServerAuthenticator.class.getName(), null);
            authTracker.open();
            defaultAuthTracker = new ServiceTracker(bc, ServerAuthenticator.class.getName(), null);
            defaultAuthTracker.open();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static BackendAuthenticator getCarbonAuthenticator(MessageContext msgContext) {
        BackendAuthenticator authenticator = null;
        Object[] legacyAuthenticatorObjects = authTracker.getServices();
        Object[] authenticatorObjects = defaultAuthTracker.getServices();
        int allAuthenticators = 0;
        if (authenticatorObjects != null) {
            allAuthenticators = authenticatorObjects.length;
        }
        if (legacyAuthenticatorObjects != null) {
            allAuthenticators += legacyAuthenticatorObjects.length;
        }
        if (allAuthenticators == 0) {
            log.debug((Object)"No authenticators registers. This is a programming error");
            return null;
        }
        BackendAuthenticator[] authenticators = new BackendAuthenticator[allAuthenticators];
        int i = 0;
        if (legacyAuthenticatorObjects != null) {
            for (Object obj : legacyAuthenticatorObjects) {
                authenticators[i] = (BackendAuthenticator)obj;
                ++i;
            }
        }
        if (authenticatorObjects != null) {
            for (Object obj : authenticatorObjects) {
                authenticators[i] = (BackendAuthenticator)obj;
                ++i;
            }
        }
        Arrays.sort(authenticators, new AuthenticatorComparator());
        for (BackendAuthenticator auth : authenticators) {
            if (auth.isDisabled() || !AuthenticatorServerRegistry.canHandle(auth, msgContext)) continue;
            authenticator = auth;
            break;
        }
        return authenticator;
    }

    private static boolean canHandle(BackendAuthenticator authenticator, MessageContext msgContext) {
        if (authenticator instanceof CarbonServerAuthenticator) {
            CarbonServerAuthenticator carbonServerAuthenticator = (CarbonServerAuthenticator)authenticator;
            return carbonServerAuthenticator.isHandle(msgContext);
        }
        ServerAuthenticator serverAuthenticator = (ServerAuthenticator)authenticator;
        return serverAuthenticator.canHandle(msgContext);
    }
}

