/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.authenticator.ldap;

import java.text.MessageFormat;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.authenticator.Authenticator;
import org.wso2.authenticator.AuthenticatorException;
import org.wso2.authenticator.help.UserHelpInfo;

public class LDAPAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(LDAPAuthenticator.class);
    private DirContext context = null;
    private String connectionName = null;
    private String connectionPass = null;
    private String userPattern = null;
    private String driverName = null;
    private String connectionUrl = null;

    public boolean authenticate(String userName, Object credentials) throws AuthenticatorException {
        boolean bValue = false;
        try {
            this.open();
            if (!(credentials instanceof String)) {
                throw new AuthenticatorException("Can handle onlyl string type credentials");
            }
            String dn = MessageFormat.format(this.userPattern, userName);
            bValue = this.bindAsUser(this.context, dn, (String)credentials);
        }
        catch (NamingException e) {
            log.debug((Object)"Unable to authenticate", (Throwable)e);
            throw new AuthenticatorException("exceptionOnAuthenticate", e);
        }
        return bValue;
    }

    protected boolean bindAsUser(DirContext context, String dn, String credentials) throws NamingException, AuthenticatorException {
        if (credentials == null || dn == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"validatingCredentials");
        }
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", credentials);
        boolean validated = false;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("binding as " + dn));
            }
            Attributes attr = context.getAttributes("", null);
            validated = true;
        }
        catch (AuthenticationException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new AuthenticatorException(e);
        }
        finally {
            if (this.connectionName != null) {
                context.addToEnvironment("java.naming.security.principal", this.connectionName);
            } else {
                context.removeFromEnvironment("java.naming.security.principal");
            }
            if (this.connectionPass != null) {
                context.addToEnvironment("java.naming.security.credentials", this.connectionPass);
            } else {
                context.removeFromEnvironment("java.naming.security.credentials");
            }
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            this.context = new InitialDirContext(this.getDirectoryContextEnvironment());
        }
        catch (NamingException e) {
            this.context = new InitialDirContext(this.getDirectoryContextEnvironment());
        }
        return this.context;
    }

    protected Hashtable getDirectoryContextEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.driverName == null || this.driverName.trim().length() == 0) {
            this.driverName = "com.sun.jndi.ldap.LdapCtxFactory";
        }
        env.put("java.naming.factory.initial", this.driverName);
        if (this.connectionName != null) {
            env.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPass != null) {
            env.put("java.naming.security.credentials", this.connectionPass);
        }
        if (this.connectionUrl != null) {
            env.put("java.naming.provider.url", this.connectionUrl);
        }
        return env;
    }

    @UserHelpInfo(isRequired=true, getHelpText="e.g. cn=root,dc=wso2,dc=com", getInputType="text", getLabel="Connection Name")
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @UserHelpInfo(isRequired=true, getHelpText="Password of the connection user name", getInputType="password", getLabel="Connection Password")
    public void setConnectionPass(String connectionPass) {
        this.connectionPass = connectionPass;
    }

    @UserHelpInfo(isRequired=true, getHelpText="e.g. uid={0},dc=wso2,dc=com", getInputType="text", getLabel="User Pattern")
    public void setUserPattern(String userPattern) {
        this.userPattern = userPattern;
    }

    @UserHelpInfo(isRequired=false, getHelpText="com.sun.jndi.ldap.LdapCtxFactory", getInputType="text", getLabel="Driver name")
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    @UserHelpInfo(isRequired=true, getHelpText="e.g. ldap://localhost:389", getInputType="text", getLabel="Connection URL")
    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }
}

