/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.MembershipListener;
import org.apache.axis2.clustering.MembershipScheme;
import org.apache.axis2.clustering.RequestBlockingHandler;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.management.DefaultGroupManagementAgent;
import org.apache.axis2.clustering.management.DefaultNodeManager;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.clustering.state.ClusteringContextListener;
import org.apache.axis2.clustering.state.DefaultStateManager;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.clustering.tribes.ApplicationMode;
import org.apache.axis2.clustering.tribes.Axis2ChannelListener;
import org.apache.axis2.clustering.tribes.Axis2GroupChannel;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.ClassLoaderUtil;
import org.apache.axis2.clustering.tribes.ClusterManagementMode;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.MulticastBasedMembershipScheme;
import org.apache.axis2.clustering.tribes.OperationMode;
import org.apache.axis2.clustering.tribes.RpcInitializationRequestHandler;
import org.apache.axis2.clustering.tribes.RpcMessagingHandler;
import org.apache.axis2.clustering.tribes.TribesAxisObserver;
import org.apache.axis2.clustering.tribes.TribesMembershipListener;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.clustering.tribes.WkaBasedMembershipScheme;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.JavaUtils;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.ErrorHandler;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.interceptors.NonBlockingCoordinator;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesClusteringAgent
implements ClusteringAgent {
    private static final Log log = LogFactory.getLog(TribesClusteringAgent.class);
    public static final String DEFAULT_SUB_DOMAIN = "__$default";
    private DefaultNodeManager configurationManager;
    private DefaultStateManager contextManager;
    private final HashMap<String, Parameter> parameters;
    private ManagedChannel channel;
    private RpcChannel rpcInitChannel;
    private RpcChannel rpcMessagingChannel;
    private ConfigurationContext configurationContext;
    private Axis2ChannelListener axis2ChannelListener;
    private ChannelSender channelSender;
    private MembershipManager primaryMembershipManager;
    private RpcInitializationRequestHandler rpcInitRequestHandler;
    private MembershipScheme membershipScheme;
    private NonBlockingCoordinator coordinator;
    private OperationMode mode;
    private List<Member> members;
    private final Map<String, Map<String, GroupManagementAgent>> groupManagementAgents = new HashMap<String, Map<String, GroupManagementAgent>>();
    private boolean clusterManagementMode;
    private RpcMessagingHandler rpcMessagingHandler;
    private List<MembershipListener> membershipListeners;

    public TribesClusteringAgent() {
        this.parameters = new HashMap();
    }

    public List<MembershipListener> getMembershipListeners() {
        return this.membershipListeners;
    }

    public void setMembershipListeners(List<MembershipListener> membershipListeners) {
        this.membershipListeners = membershipListeners;
    }

    @Override
    public void setMembers(List<Member> members) {
        this.members = members;
    }

    @Override
    public List<Member> getMembers() {
        return this.members;
    }

    @Override
    public int getAliveMemberCount() {
        return this.primaryMembershipManager.getMembers().length;
    }

    @Override
    public void addGroupManagementAgent(GroupManagementAgent agent, String applicationDomain) {
        this.addGroupManagementAgent(agent, applicationDomain, null);
    }

    @Override
    public void addGroupManagementAgent(GroupManagementAgent agent, String applicationDomain, String applicationSubDomain) {
        if (applicationSubDomain == null) {
            applicationSubDomain = DEFAULT_SUB_DOMAIN;
        }
        log.info((Object)("Managing group application domain:" + applicationDomain + ", sub-domain:" + applicationSubDomain + " using agent " + agent.getClass()));
        if (!this.groupManagementAgents.containsKey(applicationDomain)) {
            this.groupManagementAgents.put(applicationDomain, new HashMap());
            if (this.mode != null && this.mode instanceof ClusterManagementMode) {
                ((ClusterManagementMode)this.mode).addGroupManagementAgent((Channel)this.channel, applicationDomain, agent);
            }
        }
        if (agent instanceof DefaultGroupManagementAgent) {
            ((DefaultGroupManagementAgent)agent).setSender(this.channelSender);
        }
        agent.setDomain(applicationDomain);
        agent.setSubDomain(applicationSubDomain);
        this.groupManagementAgents.get(applicationDomain).put(applicationSubDomain, agent);
        this.clusterManagementMode = true;
    }

    @Override
    public GroupManagementAgent getGroupManagementAgent(String applicationDomain) {
        return this.getGroupManagementAgent(applicationDomain, null);
    }

    @Override
    public GroupManagementAgent getGroupManagementAgent(String applicationDomain, String applicationSubDomain) {
        Map<String, GroupManagementAgent> groupManagementAgentMap;
        if (applicationSubDomain == null) {
            applicationSubDomain = DEFAULT_SUB_DOMAIN;
        }
        if ((groupManagementAgentMap = this.groupManagementAgents.get(applicationDomain)) != null) {
            return groupManagementAgentMap.get(applicationSubDomain);
        }
        return null;
    }

    @Override
    public Set<String> getDomains() {
        return this.groupManagementAgents.keySet();
    }

    @Override
    public StateManager getStateManager() {
        return this.contextManager;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.configurationManager;
    }

    @Override
    public boolean isCoordinator() {
        return this.coordinator.isCoordinator();
    }

    @Override
    public void init() throws ClusteringFault {
        log.info((Object)"Initializing cluster...");
        this.addRequestBlockingHandlerToInFlows();
        this.primaryMembershipManager = new MembershipManager(this.configurationContext);
        if (this.membershipListeners != null) {
            this.primaryMembershipManager.setMembershipListeners(this.membershipListeners);
        }
        this.channel = new Axis2GroupChannel();
        this.coordinator = new NonBlockingCoordinator();
        this.channel.addInterceptor((ChannelInterceptor)this.coordinator);
        this.channel.setHeartbeat(true);
        this.channelSender = new ChannelSender((Channel)this.channel, this.primaryMembershipManager, this.synchronizeAllMembers());
        this.axis2ChannelListener = new Axis2ChannelListener(this.configurationContext, this.configurationManager, this.contextManager);
        this.channel.addChannelListener((ChannelListener)this.axis2ChannelListener);
        byte[] domain = this.getClusterDomain();
        log.info((Object)("Cluster domain: " + new String(domain)));
        this.primaryMembershipManager.setDomain(domain);
        this.rpcInitRequestHandler = new RpcInitializationRequestHandler(this.configurationContext);
        this.rpcInitChannel = new RpcChannel(TribesUtil.getRpcInitChannelId(domain), (Channel)this.channel, (RpcCallback)this.rpcInitRequestHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created RPC Init Channel for domain " + new String(domain)));
        }
        this.rpcMessagingHandler = new RpcMessagingHandler(this.configurationContext);
        this.rpcMessagingChannel = new RpcChannel(TribesUtil.getRpcMessagingChannelId(domain), (Channel)this.channel, (RpcCallback)this.rpcMessagingHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created RPC Messaging Channel for domain " + new String(domain)));
        }
        this.setMaximumRetries();
        this.configureMode(domain);
        this.configureMembershipScheme(domain, this.mode.getMembershipManagers());
        this.setMemberInfo();
        TribesMembershipListener membershipListener = new TribesMembershipListener(this.primaryMembershipManager);
        this.channel.addMembershipListener((org.apache.catalina.tribes.MembershipListener)membershipListener);
        try {
            this.channel.start(15);
            String localHost = TribesUtil.getLocalHost((Channel)this.channel);
            if (localHost.startsWith("127.0.")) {
                log.warn((Object)"Local member advertising its IP address as 127.0.0.1. Remote members will not be able to connect to this member.");
            }
        }
        catch (ChannelException e) {
            String msg = "Error starting Tribes channel";
            log.error((Object)msg, (Throwable)e);
            throw new ClusteringFault(msg, (Exception)((Object)e));
        }
        log.info((Object)("Local Member " + TribesUtil.getLocalHost((Channel)this.channel)));
        TribesUtil.printMembers(this.primaryMembershipManager);
        this.membershipScheme.joinGroup();
        this.configurationContext.getAxisConfiguration().addObservers(new TribesAxisObserver());
        ClassLoaderUtil.init(this.configurationContext.getAxisConfiguration());
        if (this.configurationManager != null) {
            this.configurationManager.setSender(this.channelSender);
            this.initializeSystem(new GetConfigurationCommand());
        }
        if (this.contextManager != null) {
            this.contextManager.setSender(this.channelSender);
            this.axis2ChannelListener.setStateManager(this.contextManager);
            this.initializeSystem(new GetStateCommand());
            ClusteringContextListener contextListener = new ClusteringContextListener(this.channelSender);
            this.configurationContext.addContextListener(contextListener);
        }
        this.configurationContext.setNonReplicableProperty("local_cluster.initialized", "true");
        log.info((Object)"Cluster initialization completed.");
    }

    @Override
    public void stop() {
        if (this.channel != null) {
            log.info((Object)"Stopping Tribes channel...");
            try {
                this.channel.stop(15);
            }
            catch (ChannelException e) {
                String msg = "Error occurred while stopping channel";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    @Override
    public List<ClusteringCommand> sendMessage(ClusteringMessage message, boolean isRpcMessage) throws ClusteringFault {
        if (this.configurationContext == null || this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
            return new ArrayList<ClusteringCommand>();
        }
        ArrayList<ClusteringCommand> responseList = new ArrayList<ClusteringCommand>();
        org.apache.catalina.tribes.Member[] members = this.primaryMembershipManager.getMembers();
        if (members.length == 0) {
            return responseList;
        }
        if (isRpcMessage) {
            try {
                Response[] responses;
                for (Response response : responses = this.rpcMessagingChannel.send(members, (Serializable)message, 3, 4, 10000L)) {
                    responseList.add((ClusteringCommand)response.getMessage());
                }
            }
            catch (ChannelException e) {
                String msg = "Error occurred while sending RPC message to cluster.";
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg, (Exception)((Object)e));
            }
        }
        try {
            this.channel.send(members, (Serializable)message, 10000, new ErrorHandler(){

                public void handleError(ChannelException e, UniqueId uniqueId) {
                    log.error((Object)("Sending failed " + uniqueId), (Throwable)e);
                }

                public void handleCompletion(UniqueId uniqueId) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending successful " + uniqueId));
                    }
                }
            });
        }
        catch (ChannelException e) {
            String msg = "Error occurred while sending message to cluster.";
            log.error((Object)msg, (Throwable)e);
            throw new ClusteringFault(msg, (Exception)((Object)e));
        }
        return responseList;
    }

    private void setMemberInfo() throws ClusteringFault {
        Parameter isActiveParam;
        Parameter port;
        TransportInDescription httpsTransport;
        Parameter port2;
        Properties memberInfo = new Properties();
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        TransportInDescription httpTransport = axisConfig.getTransportIn("http");
        int portOffset = 0;
        Parameter param = this.getParameter("AvoidInitiation");
        if (param != null && !JavaUtils.isTrueExplicitly(param.getValue()) && System.getProperty("portOffset") != null) {
            portOffset = Integer.parseInt(System.getProperty("portOffset"));
        }
        if (httpTransport != null && (port2 = httpTransport.getParameter("port")) != null) {
            memberInfo.put("httpPort", String.valueOf(Integer.valueOf((String)port2.getValue()) + portOffset));
        }
        if ((httpsTransport = axisConfig.getTransportIn("https")) != null && (port = httpsTransport.getParameter("port")) != null) {
            memberInfo.put("httpsPort", String.valueOf(Integer.valueOf((String)port.getValue()) + portOffset));
        }
        if ((isActiveParam = this.getParameter("isActive")) != null) {
            memberInfo.setProperty("isActive", (String)isActiveParam.getValue());
        }
        memberInfo.setProperty("hostName", TribesUtil.getLocalHost(this.getParameter("localMemberHost")));
        Parameter propsParam = this.getParameter("properties");
        if (propsParam != null) {
            OMElement paramEle = propsParam.getParameterElement();
            Iterator iter = paramEle.getChildrenWithLocalName("property");
            while (iter.hasNext()) {
                OMElement propEle = (OMElement)iter.next();
                OMAttribute nameAttrib = propEle.getAttribute(new QName("name"));
                if (nameAttrib == null) continue;
                String attribName = nameAttrib.getAttributeValue();
                attribName = TribesClusteringAgent.replaceProperty(attribName, memberInfo);
                OMAttribute valueAttrib = propEle.getAttribute(new QName("value"));
                if (valueAttrib == null) continue;
                String attribVal = valueAttrib.getAttributeValue();
                attribVal = TribesClusteringAgent.replaceProperty(attribVal, memberInfo);
                memberInfo.setProperty(attribName, attribVal);
            }
        }
        memberInfo.remove("hostName");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            memberInfo.store(bout, "");
        }
        catch (IOException e) {
            String msg = "Cannot store member transport properties in the ByteArrayOutputStream";
            log.error((Object)msg, (Throwable)e);
            throw new ClusteringFault(msg, e);
        }
        this.channel.getMembershipService().setPayload(bout.toByteArray());
    }

    private static String replaceProperty(String text, Properties props) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = props.getProperty(sysProp);
            if (propValue == null) {
                propValue = System.getProperty(sysProp);
            }
            if (propValue == null) continue;
            text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
        }
        return text;
    }

    private String getMembershipScheme() throws ClusteringFault {
        Parameter membershipSchemeParam = this.getParameter("membershipScheme");
        String mbrScheme = "multicast";
        if (membershipSchemeParam != null) {
            mbrScheme = ((String)membershipSchemeParam.getValue()).trim();
        }
        if (!mbrScheme.equals("multicast") && !mbrScheme.equals("wka")) {
            String msg = "Invalid membership scheme '" + mbrScheme + "'. Supported schemes are " + "multicast" + " & " + "wka";
            log.error((Object)msg);
            throw new ClusteringFault(msg);
        }
        return mbrScheme;
    }

    private byte[] getClusterDomain() {
        Parameter domainParam = this.getParameter("domain");
        byte[] domain = domainParam != null ? ((String)domainParam.getValue()).getBytes() : "apache.axis2.domain".getBytes();
        return domain;
    }

    private void setMaximumRetries() {
        Parameter maxRetriesParam = this.getParameter("maxRetries");
        int maxRetries = 10;
        if (maxRetriesParam != null) {
            maxRetries = Integer.parseInt((String)maxRetriesParam.getValue());
        }
        ReplicationTransmitter replicationTransmitter = (ReplicationTransmitter)this.channel.getChannelSender();
        MultiPointSender multiPointSender = replicationTransmitter.getTransport();
        multiPointSender.setMaxRetryAttempts(maxRetries);
    }

    private void addRequestBlockingHandlerToInFlows() {
        HandlerDescription handlerDesc;
        PhaseRule rule;
        RequestBlockingHandler requestBlockingHandler;
        Phase phase;
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        for (Phase o : axisConfig.getInFlowPhases()) {
            phase = o;
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler(requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler(requestBlockingHandler);
            log.debug((Object)"Added RequestBlockingHandler between SOAPMessageBodyBasedDispatcher & InstanceDispatcher to InFlow");
            break;
        }
        for (Phase o : axisConfig.getInFaultFlowPhases()) {
            phase = o;
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler(requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler(requestBlockingHandler);
            log.debug((Object)"Added RequestBlockingHandler between SOAPMessageBodyBasedDispatcher & InstanceDispatcher to InFaultFlow");
            break;
        }
    }

    private void configureMode(byte[] domain) {
        if (this.clusterManagementMode) {
            this.mode = new ClusterManagementMode(domain, this.groupManagementAgents, this.primaryMembershipManager);
            for (Map<String, GroupManagementAgent> agents : this.groupManagementAgents.values()) {
                for (GroupManagementAgent agent : agents.values()) {
                    if (!(agent instanceof DefaultGroupManagementAgent)) continue;
                    ((DefaultGroupManagementAgent)agent).setSender(this.channelSender);
                }
            }
        } else {
            this.mode = new ApplicationMode(domain, this.primaryMembershipManager);
        }
        this.mode.init((Channel)this.channel);
    }

    private void configureMembershipScheme(byte[] localDomain, List<MembershipManager> membershipManagers) throws ClusteringFault {
        Parameter parameter = this.getParameter("membershipListener");
        if (parameter != null) {
            MembershipListener membershipListener;
            OMElement paramEle = parameter.getParameterElement();
            String clazz = paramEle.getFirstChildWithName(new QName("class")).getText().trim();
            try {
                membershipListener = (MembershipListener)Class.forName(clazz).newInstance();
            }
            catch (Exception e) {
                String msg = "Cannot instantiate MembershipListener " + clazz;
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg, e);
            }
            OMElement propsEle = paramEle.getFirstChildWithName(new QName("properties"));
            if (propsEle != null) {
                Iterator iter = propsEle.getChildElements();
                while (iter.hasNext()) {
                    OMElement propEle = (OMElement)iter.next();
                    OMAttribute nameAttrib = propEle.getAttribute(new QName("name"));
                    if (nameAttrib == null) continue;
                    String name = nameAttrib.getAttributeValue();
                    this.setInstanceProperty(name, propEle.getText().trim(), membershipListener);
                }
            }
        }
        String scheme = this.getMembershipScheme();
        log.info((Object)("Using " + scheme + " based membership management scheme"));
        if (scheme.equals("wka")) {
            this.membershipScheme = new WkaBasedMembershipScheme(this.channel, this.mode, membershipManagers, this.primaryMembershipManager, this.parameters, localDomain, this.members, this.getBooleanParam("atmostOnceMessageSemantics"), this.getBooleanParam("preserveMessageOrder"));
        } else if (scheme.equals("multicast")) {
            this.membershipScheme = new MulticastBasedMembershipScheme(this.channel, this.mode, this.parameters, localDomain, this.getBooleanParam("atmostOnceMessageSemantics"), this.getBooleanParam("preserveMessageOrder"));
        } else {
            String msg = "Invalid membership scheme '" + scheme + "'. Supported schemes are multicast & wka";
            log.error((Object)msg);
            throw new ClusteringFault(msg);
        }
        this.membershipScheme.init();
    }

    private boolean getBooleanParam(String name) {
        Object value;
        boolean result = false;
        Parameter parameter = this.getParameter(name);
        if (parameter != null && (value = parameter.getValue()) != null) {
            result = Boolean.valueOf(((String)value).trim());
        }
        return result;
    }

    private void setInstanceProperty(String name, Object val, Object obj) throws ClusteringFault {
        String mName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method[] methods = obj.getClass().getMethods();
            boolean invoked = false;
            for (Method method1 : methods) {
                Method method;
                if (!mName.equals(method1.getName())) continue;
                Class<?>[] params = method1.getParameterTypes();
                if (params.length != 1) {
                    this.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter");
                } else if (val instanceof String) {
                    String value = (String)val;
                    if (params[0].equals(String.class)) {
                        method = obj.getClass().getMethod(mName, String.class);
                        method.invoke(obj, (Object[])new String[]{value});
                    } else if (params[0].equals(Integer.TYPE)) {
                        method = obj.getClass().getMethod(mName, Integer.TYPE);
                        method.invoke(obj, (Object[])new Integer[]{new Integer(value)});
                    } else if (params[0].equals(Long.TYPE)) {
                        method = obj.getClass().getMethod(mName, Long.TYPE);
                        method.invoke(obj, (Object[])new Long[]{new Long(value)});
                    } else if (params[0].equals(Float.TYPE)) {
                        method = obj.getClass().getMethod(mName, Float.TYPE);
                        method.invoke(obj, (Object[])new Float[]{new Float(value)});
                    } else if (params[0].equals(Double.TYPE)) {
                        method = obj.getClass().getMethod(mName, Double.TYPE);
                        method.invoke(obj, (Object[])new Double[]{new Double(value)});
                    } else if (params[0].equals(Boolean.TYPE)) {
                        method = obj.getClass().getMethod(mName, Boolean.TYPE);
                        method.invoke(obj, (Object[])new Boolean[]{Boolean.valueOf(value)});
                    } else {
                        this.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter");
                    }
                } else if (params[0].equals(OMElement.class)) {
                    method = obj.getClass().getMethod(mName, OMElement.class);
                    method.invoke(obj, (Object[])new OMElement[]{(OMElement)val});
                }
                invoked = true;
            }
            if (!invoked) {
                this.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter");
            }
        }
        catch (InvocationTargetException e) {
            this.handleException("Error invoking setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter", e);
        }
        catch (NoSuchMethodException e) {
            this.handleException("Error invoking setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter", e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Error invoking setter method named : " + mName + "() that takes a single String, int, long, float, double " + "or boolean parameter", e);
        }
    }

    private void handleException(String msg, Exception e) throws ClusteringFault {
        log.error((Object)msg, (Throwable)e);
        throw new ClusteringFault(msg, e);
    }

    private void handleException(String msg) throws ClusteringFault {
        log.error((Object)msg);
        throw new ClusteringFault(msg);
    }

    private void initializeSystem(ControlCommand command) throws ClusteringFault {
        int numberOfTries = 0;
        ArrayList<String> sentMembersList = new ArrayList<String>();
        sentMembersList.add(TribesUtil.getLocalHost((Channel)this.channel));
        org.apache.catalina.tribes.Member[] members = this.primaryMembershipManager.getMembers();
        if (members.length == 0) {
            return;
        }
        while (members.length > 0 && numberOfTries < 5) {
            block10: {
                org.apache.catalina.tribes.Member member = numberOfTries == 0 ? this.primaryMembershipManager.getLongestLivingMember() : this.primaryMembershipManager.getRandomMember();
                String memberHost = TribesUtil.getName(member);
                log.info((Object)("Trying to send initialization request to " + memberHost));
                try {
                    if (sentMembersList.contains(memberHost)) break block10;
                    Response[] responses = this.rpcInitChannel.send(new org.apache.catalina.tribes.Member[]{member}, (Serializable)command, 1, 9, 10000L);
                    if (responses.length == 0) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                    if (responses.length != 0 && responses[0] != null && responses[0].getMessage() != null) {
                        ((ControlCommand)responses[0].getMessage()).execute(this.configurationContext);
                        break;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Cannot get initialization information from " + memberHost + ". Will retry in 2 secs."), (Throwable)e);
                    sentMembersList.add(memberHost);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ignored) {
                        log.debug((Object)"Interrupted", (Throwable)ignored);
                    }
                }
            }
            if (++numberOfTries < (members = this.primaryMembershipManager.getMembers()).length) continue;
            break;
        }
    }

    @Override
    public void setNodeManager(NodeManager nodeManager) {
        this.configurationManager = (DefaultNodeManager)nodeManager;
        this.configurationManager.setSender(this.channelSender);
    }

    @Override
    public void setStateManager(StateManager stateManager) {
        this.contextManager = (DefaultStateManager)stateManager;
        this.contextManager.setSender(this.channelSender);
    }

    @Override
    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    @Override
    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    @Override
    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (String msg : this.parameters.keySet()) {
            list.add(this.parameters.get(msg));
        }
        return list;
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        Parameter parameter = this.parameters.get(parameterName);
        return parameter != null && parameter.isLocked();
    }

    @Override
    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    @Override
    public void shutdown() throws ClusteringFault {
        log.debug((Object)"Enter: TribesClusteringAgent::shutdown");
        if (this.channel != null) {
            try {
                this.channel.removeChannelListener((ChannelListener)this.rpcInitChannel);
                this.channel.removeChannelListener((ChannelListener)this.rpcMessagingChannel);
                this.channel.removeChannelListener((ChannelListener)this.axis2ChannelListener);
                this.channel.stop(15);
            }
            catch (ChannelException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: TribesClusteringAgent::shutdown");
                }
                throw new ClusteringFault((Exception)((Object)e));
            }
        }
        log.debug((Object)"Exit: TribesClusteringAgent::shutdown");
    }

    @Override
    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        if (this.rpcInitRequestHandler != null) {
            this.rpcInitRequestHandler.setConfigurationContext(configurationContext);
        }
        if (this.rpcMessagingHandler != null) {
            this.rpcMessagingHandler.setConfigurationContext(configurationContext);
        }
        if (this.axis2ChannelListener != null) {
            this.axis2ChannelListener.setConfigurationContext(configurationContext);
        }
        if (this.configurationManager != null) {
            this.configurationManager.setConfigurationContext(configurationContext);
        }
        if (this.contextManager != null) {
            this.contextManager.setConfigurationContext(configurationContext);
        }
    }

    public boolean synchronizeAllMembers() {
        Parameter syncAllParam = this.getParameter("synchronizeAll");
        return syncAllParam == null || Boolean.parseBoolean((String)syncAllParam.getValue());
    }
}

