/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ContextFinder
extends ClassLoader
implements PrivilegedAction {
    private static ThreadLocal cycleDetector = new ThreadLocal();
    static ClassLoader finderClassLoader;
    static Finder contextFinder;
    private final ClassLoader parentContextClassLoader;

    public ContextFinder(ClassLoader contextClassLoader) {
        super(contextClassLoader);
        this.parentContextClassLoader = contextClassLoader != null ? contextClassLoader : new ClassLoader(null){};
    }

    ArrayList basicFindClassLoaders() {
        Class[] stack = contextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        ClassLoader previousLoader = null;
        for (int i = 1; i < stack.length; ++i) {
            ClassLoader tmp = stack[i].getClassLoader();
            if (stack[i] == ContextFinder.class || tmp == null || tmp == this || !this.checkClassLoader(tmp) || previousLoader == tmp) continue;
            result.add(tmp);
            previousLoader = tmp;
        }
        return result;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        for (ClassLoader parent = classloader.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return false;
        }
        return true;
    }

    private ArrayList findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return (ArrayList)AccessController.doPrivileged(this);
    }

    public Object run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String name) {
        HashSet<String> classesAndResources = (HashSet<String>)cycleDetector.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            cycleDetector.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        ((Set)cycleDetector.get()).remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        if (!this.startLoading(arg0)) {
            throw new ClassNotFoundException(arg0);
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                try {
                    Class<?> clazz = ((ClassLoader)loaders.next()).loadClass(arg0);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                }
            }
            Class<?> clazz = this.parentContextClassLoader.loadClass(arg0);
            return clazz;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String arg0) {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                URL result = ((ClassLoader)loaders.next()).getResource(arg0);
                if (result == null) continue;
                URL uRL = result;
                return uRL;
            }
            URL uRL = super.getResource(arg0);
            return uRL;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration findResources(String arg0) throws IOException {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                Enumeration<URL> result = ((ClassLoader)loaders.next()).getResources(arg0);
                if (result == null || !result.hasMoreElements()) continue;
                Enumeration<URL> enumeration = result;
                return enumeration;
            }
            Enumeration<URL> enumeration = super.findResources(arg0);
            return enumeration;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                finderClassLoader = ContextFinder.class.getClassLoader();
                contextFinder = new Finder();
                return null;
            }
        });
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

