/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.wso2.carbon.bridge.CarbonAttributeWrapper;

public class CarbonHttpSession
implements HttpSession {
    private HttpSession delegate;
    private Map<String, Boolean> restrictedItems = new HashMap<String, Boolean>();

    public CarbonHttpSession(HttpSession delegate) {
        this.delegate = delegate;
        this.restrictedItems.put("carbonContextHolder", false);
        this.restrictedItems.put("is.super.tenant", false);
        this.restrictedItems.put("javax.security.auth.subject", false);
    }

    public Object getAttribute(String s) {
        Object attribute = this.delegate.getAttribute(s);
        if (attribute instanceof CarbonAttributeWrapper) {
            return ((CarbonAttributeWrapper)attribute).getObject();
        }
        return attribute;
    }

    public Object getValue(String s) {
        Object attribute = this.delegate.getAttribute(s);
        if (attribute instanceof CarbonAttributeWrapper) {
            return ((CarbonAttributeWrapper)attribute).getObject();
        }
        return attribute;
    }

    public void setAttribute(String name, Object value) {
        this.checkRestrictedItem(name);
        if (name.equals("javax.security.auth.subject")) {
            this.delegate.setAttribute(name, value);
        } else {
            this.delegate.setAttribute(name, (Object)new CarbonAttributeWrapper(value));
        }
    }

    public void putValue(String s, Object o) {
        this.delegate.putValue(s, (Object)new CarbonAttributeWrapper(o));
    }

    public void invalidate() {
        this.delegate.invalidate();
    }

    public void removeAttribute(String s) {
        this.delegate.removeAttribute(s);
    }

    public void removeValue(String s) {
        this.delegate.removeValue(s);
    }

    public long getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public long getLastAccessedTime() {
        return this.delegate.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.delegate.getServletContext();
    }

    public void setMaxInactiveInterval(int i) {
        this.delegate.setMaxInactiveInterval(i);
    }

    public int getMaxInactiveInterval() {
        return this.delegate.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.delegate.getSessionContext();
    }

    public Enumeration getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public String[] getValueNames() {
        return this.delegate.getValueNames();
    }

    public boolean isNew() {
        return this.delegate.isNew();
    }

    private void checkRestrictedItem(String itemName) {
        if (this.restrictedItems.containsKey(itemName)) {
            Boolean isSet = this.restrictedItems.get(itemName);
            if (isSet.booleanValue()) {
                throw new SecurityException("Malicious code detected! Trying to override restricted item: " + itemName + ". An incident has been logged for tenant " + this.getAttribute("tenantDomain"));
            }
            this.restrictedItems.put(itemName, true);
        }
    }
}

