/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.bridge.CarbonAttributeWrapper;
import org.wso2.carbon.bridge.CarbonHttpSession;
import org.wso2.carbon.bridge.HttpSessionManager;

public class CarbonHttpServletRequest
extends HttpServletRequestWrapper {
    private HttpServletRequest request;
    private Map<String, Boolean> restrictedItems = new HashMap<String, Boolean>();

    public CarbonHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.request = request;
        this.restrictedItems.put("tenantDomain", false);
    }

    public void setAttribute(String name, Object value) {
        this.checkRestrictedItem(name);
        if (value == null) {
            super.setAttribute(name, null);
            return;
        }
        if (value.getClass().getName().equals("java.util.Stack") || !value.getClass().getName().startsWith("javax.") && !value.getClass().getName().startsWith("java.") && !value.getClass().getName().startsWith("[Ljava.") && !(value instanceof CarbonAttributeWrapper)) {
            value = new CarbonAttributeWrapper(value);
        }
        super.setAttribute(name, value);
    }

    public Object getAttribute(String s) {
        Object attribute = super.getAttribute(s);
        if (attribute instanceof CarbonAttributeWrapper) {
            attribute = ((CarbonAttributeWrapper)attribute).getObject();
        }
        return attribute;
    }

    public HttpSession getSession(boolean create) {
        CarbonHttpSession wrappedSession = null;
        HttpSession originalSession = this.request.getSession(create);
        if (originalSession != null) {
            wrappedSession = HttpSessionManager.getSession(originalSession.getId());
        }
        return wrappedSession;
    }

    public HttpSession getSession() {
        CarbonHttpSession wrappedSession = null;
        HttpSession originalSession = this.request.getSession();
        if (originalSession != null) {
            wrappedSession = HttpSessionManager.getSession(originalSession.getId());
        }
        return wrappedSession;
    }

    public String getParameter(String name) {
        if (this.request.getCharacterEncoding() == null || this.request.getCharacterEncoding().toUpperCase().equals("ISO-8859-1")) {
            String result = this.request.getParameter(name);
            if (result == null) {
                return super.getParameter(name);
            }
            if (this.request instanceof CarbonHttpServletRequest) {
                return result;
            }
            try {
                return new String(result.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {
                return result;
            }
        }
        return super.getParameter(name);
    }

    private void checkRestrictedItem(String itemName) {
        if (this.restrictedItems.containsKey(itemName)) {
            Boolean isSet = this.restrictedItems.get(itemName);
            if (isSet.booleanValue()) {
                throw new SecurityException("Malicious code detected! Trying to override restricted item: " + itemName + ". An incident has been logged for tenant " + this.getAttribute("tenantDomain"));
            }
            this.restrictedItems.put(itemName, true);
        }
    }
}

