/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.tenant.JDBCTenantManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class CommonHybridLDAPTenantManager
extends JDBCTenantManager {
    private static Log logger = LogFactory.getLog(CommonHybridLDAPTenantManager.class);
    private LDAPConnectionContext ldapConnectionSource;
    private TenantMgtConfiguration tenantMgtConfig = null;
    private RealmConfiguration realmConfig = null;
    private static final String USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    private static final String EMAIL_ATTRIBUTE_NAME = "mail";
    private static final String SN_ATTRIBUTE_NAME = "sn";
    private static final String CN_ATTRIBUTE_NAME = "cn";

    public CommonHybridLDAPTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        super(omElement, properties);
        this.tenantMgtConfig = (TenantMgtConfiguration)properties.get("tenantMgtConfiguration");
        this.realmConfig = (RealmConfiguration)properties.get("userMgtConfiguration");
        if (this.realmConfig == null) {
            throw new UserStoreException("Tenant Manager can not function without a bootstrap realm config");
        }
        if (this.ldapConnectionSource == null) {
            this.ldapConnectionSource = new LDAPConnectionContext(this.realmConfig);
        }
    }

    public CommonHybridLDAPTenantManager(DataSource dataSource, String superTenantDomain) {
        super(dataSource, superTenantDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        int tenantID = super.addTenant(tenant);
        tenant.setId(tenantID);
        DirContext initialDirContext = null;
        try {
            initialDirContext = this.ldapConnectionSource.getContext();
            this.createOrganizationalUnit(tenant.getDomain(), (Tenant)tenant, initialDirContext);
        }
        finally {
            this.closeContext(initialDirContext);
        }
        return tenantID;
    }

    protected void createOrganizationalUnit(String orgName, Tenant tenant, DirContext initialDirContext) throws UserStoreException {
        String partitionDN = (String)this.tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
        this.createOrganizationalContext(partitionDN, orgName, initialDirContext);
        String organizationNameAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
        String dnOfOrganizationalContext = organizationNameAttribute + "=" + orgName + "," + partitionDN;
        this.createOrganizationalSubContext(dnOfOrganizationalContext, "users", initialDirContext);
        this.createOrganizationalSubContext(dnOfOrganizationalContext, "groups", initialDirContext);
        String orgSubContextAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
        String dnOfUserContext = orgSubContextAttribute + "=" + "users" + "," + dnOfOrganizationalContext;
        String dnOfUserEntry = this.createAdminEntry(dnOfUserContext, tenant, initialDirContext);
        if ("true".equals(this.realmConfig.getUserStoreProperty("WriteLDAPGroups"))) {
            String dnOfGroupContext = orgSubContextAttribute + "=" + "groups" + "," + dnOfOrganizationalContext;
            this.createAdminGroup(dnOfGroupContext, dnOfUserEntry, initialDirContext);
        }
    }

    protected void createOrganizationalContext(String rootDN, String orgName, DirContext initialDirContext) throws UserStoreException {
        DirContext subContext = null;
        DirContext organizationalContext = null;
        try {
            subContext = (DirContext)initialDirContext.lookup(rootDN);
            BasicAttributes contextAttributes = new BasicAttributes(true);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            objectClass.add(this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalObjectClass"));
            contextAttributes.put(objectClass);
            String organizationalNameAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute");
            BasicAttribute organization = new BasicAttribute(organizationalNameAttribute);
            organization.add(orgName);
            contextAttributes.put(organization);
            String rdnOfOrganizationalContext = organizationalNameAttribute + "=" + orgName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding sub context: " + rdnOfOrganizationalContext + " under " + rootDN + " ..."));
            }
            organizationalContext = subContext.createSubcontext(rdnOfOrganizationalContext, (Attributes)contextAttributes);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sub context: " + rdnOfOrganizationalContext + " was added under " + rootDN + " successfully."));
            }
            this.closeContext(organizationalContext);
            this.closeContext(subContext);
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Error occurred while adding the organizational unit sub context.";
                logger.error((Object)errorMsg, (Throwable)e);
                throw new UserStoreException(errorMsg, e);
            }
            catch (Throwable throwable) {
                this.closeContext(organizationalContext);
                this.closeContext(subContext);
                throw throwable;
            }
        }
    }

    protected void closeContext(DirContext ldapContext) {
        if (ldapContext != null) {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                logger.error((Object)"Error closing sub context.", (Throwable)e);
            }
        }
    }

    protected void createOrganizationalSubContext(String dnOfParentContext, String nameOfCurrentContext, DirContext initialDirContext) throws UserStoreException {
        DirContext subContext = null;
        DirContext organizationalContext = null;
        try {
            subContext = (DirContext)initialDirContext.lookup(dnOfParentContext);
            BasicAttributes contextAttributes = new BasicAttributes(true);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            objectClass.add(this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextObjectClass"));
            contextAttributes.put(objectClass);
            String orgSubUnitAttributeName = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
            BasicAttribute organizationSubUnit = new BasicAttribute(orgSubUnitAttributeName);
            organizationSubUnit.add(nameOfCurrentContext);
            contextAttributes.put(organizationSubUnit);
            String rdnOfOrganizationalContext = orgSubUnitAttributeName + "=" + nameOfCurrentContext;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding sub context: " + rdnOfOrganizationalContext + " under " + dnOfParentContext + " ..."));
            }
            organizationalContext = subContext.createSubcontext(rdnOfOrganizationalContext, (Attributes)contextAttributes);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sub context: " + rdnOfOrganizationalContext + " was added under " + dnOfParentContext + " successfully."));
            }
            this.closeContext(organizationalContext);
            this.closeContext(subContext);
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Error occurred while adding the organizational unit sub context.";
                logger.error((Object)errorMsg, (Throwable)e);
                throw new UserStoreException(errorMsg, e);
            }
            catch (Throwable throwable) {
                this.closeContext(organizationalContext);
                this.closeContext(subContext);
                throw throwable;
            }
        }
    }

    protected String createAdminEntry(String dnOfUserContext, Tenant tenant, DirContext initialDirContext) throws UserStoreException {
        String userDN = null;
        DirContext organizationalUsersContext = null;
        try {
            organizationalUsersContext = (DirContext)initialDirContext.lookup(dnOfUserContext);
            BasicAttributes userAttributes = new BasicAttributes(true);
            BasicAttribute objClass = new BasicAttribute("objectClass");
            objClass.add(this.realmConfig.getUserStoreProperty("UserEntryObjectClass"));
            userAttributes.put(objClass);
            BasicAttribute password = new BasicAttribute(USER_PASSWORD_ATTRIBUTE_NAME);
            String passwordToStore = UserCoreUtil.getPasswordToStore(tenant.getAdminPassword(), (String)this.realmConfig.getUserStoreProperties().get("passwordHashMethod"), this.isKDCEnabled());
            password.add(passwordToStore);
            userAttributes.put(password);
            BasicAttribute adminEmail = new BasicAttribute(EMAIL_ATTRIBUTE_NAME);
            adminEmail.add(tenant.getEmail());
            userAttributes.put(adminEmail);
            BasicAttribute lastName = new BasicAttribute(SN_ATTRIBUTE_NAME);
            lastName.add(tenant.getAdminLastName());
            userAttributes.put(lastName);
            String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            if (!CN_ATTRIBUTE_NAME.equals(userNameAttribute)) {
                BasicAttribute firstName = new BasicAttribute(CN_ATTRIBUTE_NAME);
                firstName.add(tenant.getAdminFirstName());
                userAttributes.put(firstName);
            }
            String userRDN = userNameAttribute + "=" + tenant.getAdminName();
            organizationalUsersContext.bind(userRDN, null, (Attributes)userAttributes);
            userDN = userRDN + "," + dnOfUserContext;
        }
        catch (NamingException e) {
            String errorMsg = "Error occurred while creating Admin entry";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new UserStoreException(errorMsg, e);
        }
        finally {
            this.closeContext(organizationalUsersContext);
        }
        return userDN;
    }

    protected void createAdminGroup(String dnOfGroupContext, String adminUserDN, DirContext initialDirContext) throws UserStoreException {
        BasicAttributes adminGroupAttributes = new BasicAttributes(true);
        BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
        objectClassAttribute.add(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
        adminGroupAttributes.put(objectClassAttribute);
        String groupNameAttributeName = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        BasicAttribute groupNameAttribute = new BasicAttribute(groupNameAttributeName);
        String adminRoleName = this.realmConfig.getAdminRoleName();
        groupNameAttribute.add(adminRoleName);
        adminGroupAttributes.put(groupNameAttribute);
        BasicAttribute membershipAttribute = new BasicAttribute(this.realmConfig.getUserStoreProperty("MembershipAttribute"));
        membershipAttribute.add(adminUserDN);
        adminGroupAttributes.put(membershipAttribute);
        DirContext groupContext = null;
        try {
            groupContext = (DirContext)initialDirContext.lookup(dnOfGroupContext);
            String rdnOfAdminGroup = groupNameAttributeName + "=" + adminRoleName;
            groupContext.bind(rdnOfAdminGroup, null, (Attributes)adminGroupAttributes);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while creating the admin group.";
            logger.error((Object)errorMessage);
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            this.closeContext(groupContext);
        }
    }

    private boolean isKDCEnabled() {
        return UserCoreUtil.isKdcEnabled(this.realmConfig);
    }
}

