/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.util.Date;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class LogEntryCollection {
    private int logCount;
    private DataAccessManager dataAccessManager;
    private String resourcePath;
    private int action;
    private String userName;
    private Date from;
    private Date to;
    private boolean recentFirst;

    public int getLogCount() {
        return this.logCount;
    }

    public void setLogCount(int logCount) {
        this.logCount = logCount;
    }

    public LogEntry[] getLogEntries() throws RegistryException {
        LogsDAO logsDAO = this.dataAccessManager.getDAOManager().getLogsDAO();
        return logsDAO.getLogs(this.resourcePath, this.action, this.userName, this.from, this.to, this.recentFirst, this.dataAccessManager);
    }

    public LogEntry[] getLogEntries(int start, int pageLen) throws RegistryException {
        LogsDAO logsDAO = this.dataAccessManager.getDAOManager().getLogsDAO();
        return logsDAO.getLogs(this.resourcePath, this.action, this.userName, this.from, this.to, this.recentFirst, start, pageLen, this.dataAccessManager);
    }

    public DataAccessManager getDataAccessManager() {
        return this.dataAccessManager;
    }

    public void setDataAccessManager(DataAccessManager dataAccessManager) {
        this.dataAccessManager = dataAccessManager;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setFrom(Date from) {
        if (from != null) {
            this.from = new Date(from.getTime());
        }
    }

    public void setTo(Date to) {
        if (to != null) {
            this.to = new Date(to.getTime());
        }
    }

    public void setRecentFirst(boolean recentFirst) {
        this.recentFirst = recentFirst;
    }
}

