/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCTagsDAO;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataobjects.TaggingDO;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCTagsVersionDAO
extends JDBCTagsDAO
implements TagsDAO {
    private static final Log log = LogFactory.getLog(JDBCTagsVersionDAO.class);
    private ResourceDAO resourceDAO;

    public JDBCTagsVersionDAO(DAOManager daoManager) {
        super(daoManager);
        this.resourceDAO = daoManager.getResourceDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTagging(String tagName, ResourceImpl resource, String userID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps1 = null;
        Statement ps2 = null;
        Statement ps3 = null;
        ResultSet result = null;
        try {
            String sql1 = "INSERT INTO REG_TAG (REG_TAG_NAME, REG_USER_ID, REG_TAGGED_TIME, REG_TENANT_ID) VALUES (?,?,?,?)";
            String sql2 = "SELECT MAX(REG_ID) FROM REG_TAG";
            long now = System.currentTimeMillis();
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps1 = returnsGeneratedKeys ? conn.prepareStatement(sql1, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_ID")}) : conn.prepareStatement(sql1);
            ps1.setString(1, tagName);
            ps1.setString(2, userID);
            ps1.setDate(3, new Date(now));
            ps1.setInt(4, CurrentSession.getTenantId());
            if (returnsGeneratedKeys) {
                ps1.executeUpdate();
                result = ps1.getGeneratedKeys();
            } else {
                Object object = ADD_TAG_LOCK;
                synchronized (object) {
                    ps1.executeUpdate();
                    ps2 = conn.prepareStatement(sql2);
                    result = ps2.executeQuery();
                }
            }
            if (result.next()) {
                int tagId = result.getInt(1);
                String sql3 = "INSERT INTO REG_RESOURCE_TAG (REG_TAG_ID, REG_VERSION, REG_TENANT_ID) VALUES(?,?,?)";
                ps3 = conn.prepareStatement(sql3);
                ps3.setInt(1, tagId);
                ps3.setLong(2, resource.getVersionNumber());
                ps3.setInt(3, CurrentSession.getTenantId());
                ps3.executeUpdate();
            }
        }
        catch (SQLException e) {
            String msg = "Failed to add tag " + tagName + " to resource " + resource.getPath() + " by user " + userID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        try {
                            if (ps2 != null) {
                                ps2.close();
                            }
                        }
                        finally {
                            if (ps3 != null) {
                                ps3.close();
                            }
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaggings(ResourceImpl resource, TaggingDO[] taggingDOs) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        long now = System.currentTimeMillis();
        for (TaggingDO taggingDO : taggingDOs) {
            Statement ps = null;
            Statement ps2 = null;
            ResultSet result = null;
            try {
                String sql = "INSERT INTO REG_TAG (REG_TAG_NAME, REG_USER_ID, REG_TAGGED_TIME, REG_TENANT_ID) VALUES (?,?,?,?)";
                String dbProductName = conn.getMetaData().getDatabaseProductName();
                ps = conn.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_ID")});
                ps.setString(1, taggingDO.getTagName());
                ps.setString(2, taggingDO.getTaggedUserName());
                ps.setDate(3, new Date(now));
                ps.setInt(4, CurrentSession.getTenantId());
                ps.executeUpdate();
                result = ps.getGeneratedKeys();
                if (!result.next()) continue;
                int tagId = result.getInt(1);
                String sql2 = "INSERT INTO REG_RESOURCE_TAG (REG_TAG_ID, REG_VERSION, REG_TENANT_ID) VALUES(?,?,?)";
                ps2 = conn.prepareStatement(sql2);
                ps2.setInt(1, tagId);
                ps2.setLong(2, resource.getVersionNumber());
                ps2.setInt(3, CurrentSession.getTenantId());
                ps2.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "Failed to add tags to resource " + resource.getPath() + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            finally {
                try {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    finally {
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                        finally {
                            if (ps2 != null) {
                                ps2.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                    log.error((Object)msg, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void copyTags(ResourceImpl fromResource, ResourceImpl toResource) throws RegistryException {
        List<TaggingDO> tagList = this.getTagDOs(fromResource);
        this.addTaggings(toResource, tagList.toArray(new TaggingDO[tagList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean taggingExists(String tagName, ResourceImpl resourceImpl, String userID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT T.REG_ID FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE LOWER(T.REG_TAG_NAME)=? AND T.REG_USER_ID =? AND T.REG_ID=RT.REG_TAG_ID AND RT.REG_VERSION=? AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            if (tagName == null) {
                ps.setString(1, null);
            } else {
                ps.setString(1, tagName.toLowerCase());
            }
            ps.setString(2, userID);
            ps.setLong(3, resourceImpl.getVersionNumber());
            ps.setInt(4, CurrentSession.getTenantId());
            ps.setInt(5, CurrentSession.getTenantId());
            result = ps.executeQuery();
            boolean tagExists = false;
            if (result.next()) {
                tagExists = true;
            }
            boolean bl = tagExists;
            return bl;
        }
        catch (SQLException e) {
            String msg = "Failed to check the existence of the tag " + tagName + " on resource " + resourceImpl.getPath() + " by user " + userID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTags(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet results = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT T.REG_TAG_NAME FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE T.REG_ID=RT.REG_TAG_ID AND RT.REG_VERSION=? AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            results = ps.executeQuery();
            ArrayList<String> tagList = new ArrayList<String>();
            while (results.next()) {
                tagList.add(results.getString("REG_TAG_NAME"));
            }
            String[] stringArray = tagList.toArray(new String[tagList.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get tags associated with the resource path " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaggingDO> getTagDOs(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet results = null;
        PreparedStatement ps = null;
        ArrayList<Object> tagList = new ArrayList<Object>();
        try {
            Object taggingDO;
            String sql = "SELECT T.REG_TAG_NAME, T.REG_USER_ID, T.REG_TAGGED_TIME FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE T.REG_ID=RT.REG_TAG_ID AND RT.REG_VERSION=? AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                taggingDO = new TaggingDO();
                ((TaggingDO)taggingDO).setTagName(results.getString(1));
                ((TaggingDO)taggingDO).setTaggedUserName(results.getString(2));
                ((TaggingDO)taggingDO).setTaggedTime(results.getDate(3));
                tagList.add(taggingDO);
            }
            taggingDO = tagList;
            return taggingDO;
        }
        catch (SQLException e) {
            String msg = "Failed to get tags associated with the resource path " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPathsWithAnyTag(String[] tags) throws RegistryException {
        if (tags == null || tags.length == 0) {
            return null;
        }
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT RT.REG_VERSION FROM REG_RESOURCE_TAG RT, REG_TAG T WHERE RT.REG_TAG_ID=T.REG_ID ");
        stringBuilder.append(" AND (");
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append("lower(T.REG_TAG_NAME)=?");
        }
        stringBuilder.append(") AND RT.REG_TENANT_ID=? AND T.REG_TENANT_ID=?");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        ResultSet results = null;
        PreparedStatement s = null;
        try {
            int i;
            s = conn.prepareStatement(stringBuilder.toString());
            for (i = 0; i < tags.length; ++i) {
                if (tags[i] == null) {
                    s.setString(1, tags[i]);
                    continue;
                }
                s.setString(1, tags[i].toLowerCase());
            }
            s.setInt(i + 1, CurrentSession.getTenantId());
            s.setInt(i + 2, CurrentSession.getTenantId());
            results = s.executeQuery();
            while (results.next()) {
                String path;
                long version = results.getLong("REG_VERSION");
                if (version <= 0L || (path = this.resourceDAO.getPath(version)) == null) continue;
                resourcePaths.add(path);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to resource paths with any of the tags " + Arrays.toString(tags) + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return resourcePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTagCount(ResourceImpl resourceImpl, String tag) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT COUNT(T.REG_TAG_NAME) FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE lower(T.REG_TAG_NAME)=? AND T.REG_ID=RT.REG_TAG_ID AND RT.REG_VERSION=? AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=? GROUP BY RT.REG_VERSION";
            ps = conn.prepareStatement(sql);
            if (tag == null) {
                ps.setString(1, null);
            } else {
                ps.setString(1, tag.toLowerCase());
            }
            ps.setLong(2, resourceImpl.getVersionNumber());
            ps.setInt(3, CurrentSession.getTenantId());
            ps.setInt(4, CurrentSession.getTenantId());
            result = ps.executeQuery();
            long tagCount = 0L;
            if (result.next()) {
                tagCount = result.getLong(1);
            }
            long l = tagCount;
            return l;
        }
        catch (SQLException e) {
            String msg = "Failed to get tag count of tag " + tag + " on resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag[] getTagsWithCount(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        ResultSet result = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT T.REG_TAG_NAME, COUNT(T.REG_ID) FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE RT.REG_VERSION=? AND T.REG_ID=RT.REG_TAG_ID AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=? GROUP BY T.REG_TAG_NAME";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            result = ps.executeQuery();
            while (result.next()) {
                Tag tag = new Tag();
                tag.setTagName(result.getString("REG_TAG_NAME"));
                tag.setTagCount(result.getLong(2));
                tagList.add(tag);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get tags and tag counts of the resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return tagList.toArray(new Tag[tagList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggingDO[] getTagging(ResourceImpl resource, String tag, String userID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        Statement ps = null;
        ArrayList<TaggingDO> taggingDOs = new ArrayList<TaggingDO>();
        try {
            String sql = "SELECT T.REG_ID, T.REG_TAGGED_TIME FROM REG_TAG T, REG_RESOURCE_TAG RT  WHERE RT.REG_VERSION = ? AND RT.REG_TAG_ID=T.REG_ID  AND T.REG_TAG_NAME=? ";
            if (!userID.equals("*")) {
                sql = sql + "AND T.REG_USER_ID=? ";
            }
            sql = sql + " AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=? ";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resource.getVersionNumber());
            ps.setString(2, tag);
            int nextParam = 3;
            if (!userID.equals("*")) {
                ps.setString(nextParam, userID);
                ++nextParam;
            }
            ps.setInt(nextParam, CurrentSession.getTenantId());
            ps.setInt(++nextParam, CurrentSession.getTenantId());
            result = ps.executeQuery();
            while (result.next()) {
                java.util.Date taggedTime = new java.util.Date(result.getTimestamp("REG_TAGGED_TIME").getTime());
                TaggingDO taggingDO = new TaggingDO();
                taggingDO.setResourcePath(resource.getPath());
                taggingDO.setTagName(tag);
                taggingDO.setTaggedTime(taggedTime);
                taggingDO.setTaggedUserName(userID);
                taggingDO.setTagID(result.getLong("REG_ID"));
                taggingDOs.add(taggingDO);
            }
            TaggingDO[] taggingDOArray = taggingDOs.toArray(new TaggingDO[taggingDOs.size()]);
            return taggingDOArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get tagging information for tag " + tag + " on resource " + resource.getPath() + " by user " + userID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggingDO[] getTagging(ResourceImpl resource) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ArrayList<TaggingDO> taggingDOs = new ArrayList<TaggingDO>();
        ResultSet results = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT T.REG_ID, T.REG_TAG_NAME, T.REG_USER_ID, T.REG_TAGGED_TIME FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE RT.REG_VERSION =? AND RT.REG_TAG_ID=T.REG_ID AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resource.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                java.util.Date taggedTime = new java.util.Date(results.getTimestamp("REG_TAGGED_TIME").getTime());
                TaggingDO taggingDO = new TaggingDO();
                taggingDO.setResourcePath(resource.getPath());
                taggingDO.setTagName(results.getString("REG_TAG_NAME"));
                taggingDO.setTaggedTime(taggedTime);
                taggingDO.setTaggedUserName(results.getString("REG_USER_ID"));
                taggingDO.setTagID(results.getLong("REG_ID"));
                taggingDOs.add(taggingDO);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get tagging information for the resource " + resource.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return taggingDOs.toArray(new TaggingDO[taggingDOs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggingDO getTagging(long taggingID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ResultSet result = null;
        PreparedStatement s = null;
        try {
            String sql = "SELECT T.REG_USER_ID, T.REG_TAG_NAME, T.REG_TAGGED_TIME, RT.REG_VERSION FROM REG_TAG T, REG_RESOURCE_TAG RT WHERE T.REG_ID=? AND T.REG_ID=RT.REG_TAG_ID AND T.REG_TENANT_ID=? AND RT.REG_TENANT_ID=?";
            s = conn.prepareStatement(sql);
            s.setLong(1, taggingID);
            s.setInt(2, CurrentSession.getTenantId());
            s.setInt(3, CurrentSession.getTenantId());
            TaggingDO taggingDO = null;
            result = s.executeQuery();
            if (result.next()) {
                java.util.Date taggedTime = new java.util.Date(result.getTimestamp("REG_TAGGED_TIME").getTime());
                taggingDO = new TaggingDO();
                taggingDO.setTagName(result.getString("REG_TAG_NAME"));
                taggingDO.setTaggedUserName(result.getString("REG_USER_ID"));
                taggingDO.setTaggedTime(taggedTime);
                long version = result.getLong("REG_VERSION");
                String resourcePath = null;
                if (version > 0L) {
                    resourcePath = this.resourceDAO.getPath(version);
                }
                if (resourcePath != null) {
                    taggingDO.setResourcePath(resourcePath);
                }
            }
            TaggingDO taggingDO2 = taggingDO;
            return taggingDO2;
        }
        catch (SQLException e) {
            String msg = "Failed to get tagging information for tag ID " + taggingID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public ResourceImpl getResourceWithMinimumData(String path) throws RegistryException {
        return RegistryUtils.getResourceWithMinimumData(path, this.resourceDAO, true);
    }

    @Override
    public void moveTags(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
    }

    @Override
    public void moveTagPaths(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
    }
}

