/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.url.mapper.HotUpdateService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;

public class TomcatUtil {
    private static CarbonTomcatService carbonTomcatService;
    private static Map<String, TomcatGenericWebappsDeployer> webappsDeployers;

    public static boolean checkUnpackWars() {
        CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
        return carbonTomcatService.isUnpackWARs();
    }

    public static void addWebappsDeployer(String webappsDir, TomcatGenericWebappsDeployer webappsDeployer) {
        CarbonUtils.checkSecurity();
        webappsDeployers.put(webappsDir, webappsDeployer);
    }

    public static Map<String, TomcatGenericWebappsDeployer> getWebappsDeployers() {
        CarbonUtils.checkSecurity();
        return Collections.unmodifiableMap(webappsDeployers);
    }

    public static void remapRequest(HttpServletRequest request) throws Exception {
        Request connectorReq = (Request)request;
        MappingData mappingData = connectorReq.getMappingData();
        mappingData.recycle();
        connectorReq.getConnector().getMapper().map(connectorReq.getCoyoteRequest().serverName(), connectorReq.getCoyoteRequest().decodedURI(), null, mappingData);
        connectorReq.setContext((Context)connectorReq.getMappingData().context);
        connectorReq.setWrapper((Wrapper)connectorReq.getMappingData().wrapper);
    }

    public static String getApplicationNameFromContext(String contextName) {
        String appName = null;
        if (contextName.contains("webapps") || contextName.contains("jaggeryapps") || contextName.contains("jaxwebapps")) {
            if (contextName.startsWith("#")) {
                String[] temp = contextName.split("#");
                appName = temp[temp.length - 1];
            } else if (contextName.startsWith("/")) {
                String[] temp = contextName.split("/");
                appName = temp[temp.length - 1];
            }
        } else {
            appName = contextName;
        }
        return appName;
    }

    public static Boolean isVirtualHostRequest(String requestedHostName) {
        Boolean isVirtualHostRequest = false;
        HotUpdateService hotUpdate = DataHolder.getHotUpdateService();
        if (hotUpdate != null && requestedHostName.endsWith(hotUpdate.getSuffixOfHost())) {
            isVirtualHostRequest = true;
        }
        return isVirtualHostRequest;
    }

    static {
        webappsDeployers = new HashMap<String, TomcatGenericWebappsDeployer>();
    }
}

