/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.AuthenticationException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.LDAPUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class ReadOnlyLDAPUserStoreManager
extends AbstractUserStoreManager {
    protected LDAPConnectionContext connectionSource = null;
    protected UserRealm realm = null;
    protected String adminUserName = null;
    protected int tenantID;
    private final int MAX_USER_CACHE = 200;
    private Map<String, String> userCache = new ConcurrentHashMap<String, String>(200);
    protected static final String SERVER_PRINCIPAL_ATTRIBUTE_VALUE = "Service";
    private static Log log = LogFactory.getLog(ReadOnlyLDAPUserStoreManager.class);
    protected boolean readLDAPUserGroups = false;
    protected boolean writeLDAPUserGroups = false;
    protected String userSearchBase = null;
    protected String groupSearchBase = null;
    protected boolean emptyRolesAllowed = false;

    public ReadOnlyLDAPUserStoreManager() {
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.profileManager = profileManager;
        this.userRealm = realm;
        this.tenantID = tenantId;
        this.checkRequiredUserStoreConfigurations();
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, tenantId, realmConfig, this.userRealm);
        this.connectionSource = new LDAPConnectionContext(realmConfig);
        try {
            this.connectionSource.getContext();
            log.info((Object)"LDAP connection created successfully in read-only mode");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException("Cannot create connection to Active directory server. Error message " + e.getMessage());
        }
        this.realm = realm;
        this.checkInitialData();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
        this.adminUserName = realmConfig.getAdminUserName();
        this.initUserRolesCache();
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.profileManager = profileManager;
        this.checkRequiredUserStoreConfigurations();
        this.connectionSource = new LDAPConnectionContext(realmConfig);
    }

    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        log.debug((Object)"Checking LDAP configurations ..");
        String connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        if (connectionURL == null || connectionURL.equals("")) {
            throw new UserStoreException("Required ConnectionURL property is not set at the LDAP configurations");
        }
        String connectionName = this.realmConfig.getUserStoreProperty("ConnectionName");
        if (connectionName == null || connectionName.equals("")) {
            throw new UserStoreException("Required ConnectionNme property is not set at the LDAP configurations");
        }
        String connectionPassword = this.realmConfig.getUserStoreProperty("ConnectionPassword");
        if (connectionPassword == null || connectionPassword.equals("")) {
            throw new UserStoreException("Required ConnectionPassword property is not set at the LDAP configurations");
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (this.userSearchBase == null || this.userSearchBase.equals("")) {
            throw new UserStoreException("Required UserSearchBase property is not set at the LDAP configurations");
        }
        String usernameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        if (usernameListFilter == null || usernameListFilter.equals("")) {
            throw new UserStoreException("Required UserNameListFilter property is not set at the LDAP configurations");
        }
        String usernameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        if (usernameAttribute == null || usernameAttribute.equals("")) {
            throw new UserStoreException("Required UserNameAttribute property is not set at the LDAP configurations");
        }
        this.readLDAPUserGroups = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("ReadLDAPGroups"));
        if (this.readLDAPUserGroups) {
            this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            if (this.groupSearchBase == null || this.groupSearchBase.equals("")) {
                throw new UserStoreException("Required GroupSearchBase property is not set at the LDAP configurations");
            }
            String groupNameListFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            if (groupNameListFilter == null || groupNameListFilter.equals("")) {
                throw new UserStoreException("Required GroupNameListFilter property is not set at the LDAP configurations");
            }
            String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            if (groupNameAttribute == null || groupNameAttribute.equals("")) {
                throw new UserStoreException("Required GroupNameAttribute property is not set at the LDAP configurations");
            }
            String memebershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            if (memebershipAttribute == null || memebershipAttribute.equals("")) {
                throw new UserStoreException("Required MembershipAttribute property is not set at the LDAP configurations");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        if (userName == null) return false;
        if (credential == null) {
            return false;
        }
        userName = userName.trim();
        userName = this.replaceEscapeCharacters(userName);
        String password = (String)credential;
        password = password.trim();
        if (userName.equals("")) return false;
        if (password.equals("")) {
            return false;
        }
        boolean bValue = false;
        String name = null;
        String patterns = this.realmConfig.getUserStoreProperty("UserDNPattern");
        if (patterns != null && !patterns.isEmpty()) {
            String[] userDNPatternList;
            name = this.userCache.get(userName);
            if (name != null) {
                block12: {
                    try {
                        bValue = this.bindAsUser(name, (String)credential);
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)("Checking authentication with UserDN " + name + "failed " + e.getStackTrace()));
                    }
                }
                if (bValue) {
                    return bValue;
                }
            }
            if ((userDNPatternList = patterns.split("#")).length <= 0) return bValue;
            String[] arr$ = userDNPatternList;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                block13: {
                    String userDNPattern = arr$[i$];
                    name = MessageFormat.format(userDNPattern, userName);
                    try {
                        if (name == null || !(bValue = this.bindAsUser(name, (String)credential))) break block13;
                        this.userCache.put(userName, name);
                        return bValue;
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)("Checking authentication with UserDN " + userDNPattern + "failed " + e.getStackTrace()));
                    }
                }
                ++i$;
            }
            return bValue;
        }
        name = this.getNameInSpaceForUserName(userName);
        try {
            if (name == null) return bValue;
            return this.bindAsUser(name, (String)credential);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    @Override
    public String[] getAllProfileNames() throws UserStoreException {
        return new String[]{"default"};
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        return new String[]{"default"};
    }

    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        HashMap<String, String> values = new HashMap<String, String>();
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        searchFilter = "(&" + searchFilter + "(" + userNameProperty + "=" + userName + "))";
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        NamingEnumeration<?> attrs = null;
        try {
            answer = this.searchForUser(searchFilter, propertyNames, dirContext);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                if (attributes == null) continue;
                for (String name : propertyNames) {
                    Attribute attribute = attributes.get(name);
                    if (attribute == null) continue;
                    StringBuffer attrBuffer = new StringBuffer();
                    attrs = attribute.getAll();
                    while (attrs.hasMore()) {
                        String attr = (String)attrs.next();
                        if (attr == null || attr.trim().length() <= 0) continue;
                        attrBuffer.append(attr + ",");
                    }
                    String value = attrBuffer.toString();
                    if (value == null || value.trim().length() <= 1) continue;
                    value = value.substring(0, value.length() - 1);
                    values.put(name, value);
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return values;
    }

    public String[] getUserRoles(String userName) throws UserStoreException {
        return new String[0];
    }

    @Override
    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean isExisting = false;
        if (this.hybridRoleManager.isExistingRole(roleName)) {
            isExisting = true;
        } else if ("true".equals(this.realmConfig.getUserStoreProperty("ReadLDAPGroups"))) {
            String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + roleName + "))";
            String searchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            searchCtls.setReturningAttributes(new String[]{roleNameProperty});
            if (this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty).size() > 0) {
                isExisting = true;
            }
        }
        return isExisting;
    }

    @Override
    public boolean isExistingUser(String userName) throws UserStoreException {
        if ("wso2.system.user".equals(userName)) {
            return true;
        }
        boolean bFound = false;
        try {
            String name = this.getNameInSpaceForUserName(userName);
            if (name != null && name.length() > 0) {
                bFound = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        return bFound;
    }

    @Override
    public String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        Object[] userNames = new String[]{};
        if (maxItemLimit == 0) {
            return userNames;
        }
        int givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setCountLimit(maxItemLimit);
        if (filter.contains("?") || filter.contains("**")) {
            throw new UserStoreException("Invalid character sequence entered for user serch. Please enter valid sequence.");
        }
        StringBuffer searchFilter = null;
        searchFilter = new StringBuffer(this.realmConfig.getUserStoreProperty("UserNameListFilter"));
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        StringBuffer buff = new StringBuffer();
        buff.append("(&").append(searchFilter).append("(").append(userNameProperty).append("=").append(filter).append("))");
        String serviceNameAttribute = "sn";
        String[] returnedAtts = new String[]{userNameProperty, serviceNameAttribute};
        searchCtls.setReturningAttributes(returnedAtts);
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, buff.toString(), searchCtls);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (answer.hasMoreElements() && i < maxItemLimit) {
                String serviceName;
                SearchResult sr = answer.next();
                if (sr.getAttributes() == null) continue;
                Attribute attr = sr.getAttributes().get(userNameProperty);
                Attribute attrSurname = sr.getAttributes().get(serviceNameAttribute);
                if (attrSurname != null && (serviceName = (String)attrSurname.get()) != null && serviceName.equals(SERVER_PRINCIPAL_ATTRIBUTE_VALUE) || attr == null) continue;
                String name = (String)attr.get();
                list.add(name);
                ++i;
            }
            userNames = list.toArray(new String[list.size()]);
            Arrays.sort(userNames);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return userNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bindAsUser(String dn, String credentials) throws NamingException, UserStoreException {
        boolean isAuthed = false;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", credentials);
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        env.put("org.wso2.carbon.context.RequestBaseContext", "true");
        String rawConnectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        String portInfo = rawConnectionURL.split(":")[2];
        String connectionURL = null;
        String port = null;
        if (portInfo.contains("${") && portInfo.contains("}")) {
            port = Integer.toString(CarbonUtils.getPortFromServerConfig((String)portInfo));
            connectionURL = rawConnectionURL.replace(portInfo, port);
        }
        if (port == null) {
            connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        }
        env.put("java.naming.provider.url", connectionURL);
        env.put("java.naming.security.authentication", "simple");
        InitialLdapContext cxt = null;
        try {
            cxt = new InitialLdapContext(env, null);
            isAuthed = true;
        }
        catch (AuthenticationException e) {
            block6: {
                try {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("Authentication failed " + e.getExplanation().toString()));
                }
                catch (Throwable throwable) {
                    JNDIUtil.closeContext(cxt);
                    throw throwable;
                }
            }
            JNDIUtil.closeContext(cxt);
        }
        JNDIUtil.closeContext(cxt);
        return isAuthed;
    }

    protected NamingEnumeration<SearchResult> searchForUser(String searchFilter, String[] returnedAtts, DirContext dirContext) throws UserStoreException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (returnedAtts != null && returnedAtts.length > 0) {
            searchCtls.setReturningAttributes(returnedAtts);
        }
        try {
            NamingEnumeration<SearchResult> answer = dirContext.search(searchBase, searchFilter, searchCtls);
            return answer;
        }
        catch (NamingException e) {
            log.error((Object)"Search failed.", (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
    }

    @Override
    public void doAddRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        if (this.isExistingRole(roleName)) {
            throw new UserStoreException("Duplicate role name in the system. Please pick another name");
        }
        this.hybridRoleManager.addHybridRole(roleName, userList);
        if (userList != null && userList.length != 0) {
            this.clearUserRolesCacheByTenant(this.tenantID);
        }
        if (permissions != null) {
            for (Permission permission : permissions) {
                String resourceId = permission.getResourceId();
                String action = permission.getAction();
                this.userRealm.getAuthorizationManager().authorizeRole(roleName, resourceId, action);
            }
        }
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Duplicate role name in the system. Please pick another name");
        }
        this.hybridRoleManager.updateHybridRoleName(roleName, newRoleName);
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    @Override
    public boolean isBulkImportSupported() {
        return false;
    }

    public boolean isMultipleProfilesAllowed() {
        return false;
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        this.hybridRoleManager.deleteHybridRole(roleName);
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    @Override
    public String[] getRoleNames() throws UserStoreException {
        return this.getRoleNames(false);
    }

    @Override
    public String[] getRoleNames(boolean noHybridRoles) throws UserStoreException {
        List<String> externalRoles = new ArrayList<String>();
        if ("true".equals(this.realmConfig.getUserStoreProperty("ReadLDAPGroups"))) {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            String searchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            String[] returnedAtts = new String[]{roleNameProperty};
            searchCtls.setReturningAttributes(returnedAtts);
            externalRoles = this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty);
        }
        Collections.addAll(externalRoles, this.getAllSecondaryRoles());
        if (!noHybridRoles) {
            String[] internalRoles = this.hybridRoleManager.getHybridRoles();
            return UserCoreUtil.combine(internalRoles, externalRoles);
        }
        return externalRoles.toArray(new String[externalRoles.size()]);
    }

    @Override
    public RoleDTO[] getRoleNamesWithDomain() throws UserStoreException {
        return this.getRoleNamesWithDomain(false);
    }

    @Override
    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfig;
    }

    public RoleDTO[] getRoleNamesWithDomain(boolean noHybridRoles) throws UserStoreException {
        ArrayList<RoleDTO> externalRoles = new ArrayList<RoleDTO>();
        String domain = this.realmConfig.getUserStoreProperty("DomainName");
        if ("true".equals(this.realmConfig.getUserStoreProperty("ReadLDAPGroups"))) {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            String searchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            String[] returnedAtts = new String[]{roleNameProperty};
            searchCtls.setReturningAttributes(returnedAtts);
            List<String> externalRoleNames = this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty);
            if (externalRoleNames != null && !externalRoleNames.isEmpty()) {
                externalRoles.addAll(Arrays.asList(UserCoreUtil.convertRoleNamesToRoleDTO(externalRoleNames.toArray(new String[externalRoles.size()]), domain)));
            }
        }
        Collections.addAll(externalRoles, this.getAllSecondaryRoleDTOs());
        if (!noHybridRoles) {
            String[] internalRoles = this.hybridRoleManager.getHybridRoles();
            if (internalRoles != null && internalRoles.length != 0) {
                externalRoles.addAll(Arrays.asList(UserCoreUtil.convertRoleNamesToRoleDTO(internalRoles, domain)));
            }
            return externalRoles.toArray(new RoleDTO[externalRoles.size()]);
        }
        return externalRoles.toArray(new RoleDTO[externalRoles.size()]);
    }

    @Override
    public String[] getUserListOfRole(String roleName) throws UserStoreException {
        String[] names = new String[]{};
        if (this.hybridRoleManager.isExistingRole(roleName)) {
            names = this.hybridRoleManager.getUserListOfHybridRole(roleName);
        } else if ("true".equals(this.realmConfig.getUserStoreProperty("ReadLDAPGroups"))) {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + roleName + "))";
            String searchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            String[] returnedAtts = new String[]{membershipProperty};
            searchCtls.setReturningAttributes(returnedAtts);
            List<String> list = this.getAttributeListOfOneElement(searchBase, searchFilter, searchCtls);
            names = list.toArray(new String[list.size()]);
        }
        return names;
    }

    protected String getEffectiveSearchBase() {
        String backLinksEnabled = this.realmConfig.getUserStoreProperty("BackLinksEnabled");
        boolean isBackLinkEnabled = false;
        if (backLinksEnabled != null && !backLinksEnabled.equals("")) {
            isBackLinkEnabled = Boolean.parseBoolean(backLinksEnabled);
        }
        if (isBackLinkEnabled) {
            return this.realmConfig.getUserStoreProperty("UserSearchBase");
        }
        return this.realmConfig.getUserStoreProperty("GroupSearchBase");
    }

    @Override
    public List<String> getExternalRoleListOfUser(String userName) throws UserStoreException {
        List<String> list = new ArrayList<String>();
        if ("true".equals(this.realmConfig.getUserStoreProperty("ReadLDAPGroups")) && !userName.equals("wso2.anonymous.user") && !userName.equals("wso2.system.user")) {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchBase = this.getEffectiveSearchBase();
            String memberOfProperty = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
            if (memberOfProperty != null && memberOfProperty.length() > 0) {
                String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                searchFilter = "(&" + searchFilter + "(" + userNameProperty + "=" + userName + "))";
                String binaryAttribute = this.realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary");
                String primaryGroupId = this.realmConfig.getUserStoreProperty("PrimaryGroupId");
                String[] returnedAtts = new String[]{memberOfProperty};
                if (binaryAttribute != null && primaryGroupId != null) {
                    returnedAtts = new String[]{memberOfProperty, binaryAttribute, primaryGroupId};
                }
                searchCtls.setReturningAttributes(returnedAtts);
                list = binaryAttribute != null && primaryGroupId != null ? this.getAttributeListOfOneElementWithPrimarGroup(searchBase, searchFilter, searchCtls, binaryAttribute, primaryGroupId, userNameProperty, memberOfProperty) : this.getAttributeListOfOneElement(searchBase, searchFilter, searchCtls);
            } else {
                String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
                String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                if (membershipProperty == null || membershipProperty.length() < 1) {
                    throw new UserStoreException("Please set member of attribute or membership attribute");
                }
                String nameInSpace = this.getNameInSpaceForUserName(userName);
                searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + nameInSpace + "))";
                String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                String[] returnedAtts = new String[]{roleNameProperty};
                searchCtls.setReturningAttributes(returnedAtts);
                list = this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty);
            }
        } else if ("wso2.anonymous.user".equals(userName)) {
            list.add("wso2.anonymous.role");
        }
        return list;
    }

    @Override
    public String[] getInternalRoleListOfUser(String userName) throws UserStoreException {
        return this.hybridRoleManager.getHybridRoleListOfUser(userName);
    }

    @Override
    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        String domain;
        UserStoreManager secManager;
        int index;
        String tmpUserName;
        String[] roleList;
        block6: {
            roleList = null;
            tmpUserName = userName;
            try {
                roleList = this.getRoleListOfUserFromCache(this.tenantID, userName);
                if (roleList != null) {
                    return roleList;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("Roles does not exist in the cache for user " + userName));
            }
        }
        boolean domainMatched = false;
        List<String> secondaryRoles = null;
        if (this.getSecondaryUserStoreManager() != null && (index = userName.indexOf("/")) > 0 && (secManager = this.getSecondaryUserStoreManager(domain = userName.substring(0, index))) != null) {
            domainMatched = true;
            userName = userName.substring(index + 1);
            return secManager.getRoleListOfUser(userName);
        }
        if (!domainMatched) {
            secondaryRoles = this.getSecondaryRoleListOfUser(userName);
        }
        String[] internalRoles = this.getInternalRoleListOfUser(userName);
        List<String> externalRoles = this.getExternalRoleListOfUser(userName);
        if (secondaryRoles != null) {
            externalRoles.addAll(secondaryRoles);
        }
        roleList = UserCoreUtil.combine(internalRoles, externalRoles);
        this.addToUserRolesCache(this.tenantID, tmpUserName, roleList);
        return roleList;
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return true;
    }

    @Override
    public String[] getHybridRoles() throws UserStoreException {
        return this.hybridRoleManager.getHybridRoles();
    }

    private void checkInitialData() throws UserStoreException {
        if (!this.isExistingUser(this.realmConfig.getAdminUserName())) {
            log.warn((Object)"If the user not found in the primary user store Carbon cannot start");
        }
        if (!this.isExistingRole(this.realmConfig.getAdminRoleName())) {
            this.addRole(this.realmConfig.getAdminRoleName(), new String[]{this.realmConfig.getAdminUserName()}, (Permission[])null);
        }
        if (!this.isExistingRole(this.realmConfig.getEveryOneRoleName())) {
            String[] users = new String[]{this.realmConfig.getAdminUserName()};
            this.addRole(this.realmConfig.getEveryOneRoleName(), users, (Permission[])null);
        }
        if (!this.isExistingRole("wso2.anonymous.role")) {
            this.addRole("wso2.anonymous.role", new String[]{"wso2.anonymous.user"}, (Permission[])null);
        }
    }

    protected String getNameInSpaceForUserName(String userName) throws UserStoreException {
        StringBuffer searchFilter = new StringBuffer(this.realmConfig.getUserStoreProperty("UserNameListFilter"));
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        StringBuffer buff = new StringBuffer();
        buff.append("(&").append(searchFilter).append("(").append(userNameProperty).append("=").append(userName).append("))");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for " + buff.toString()));
        }
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        try {
            String name = null;
            answer = this.searchForUser(buff.toString(), null, dirContext);
            int count = 0;
            NameClassPair userObj = null;
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                if (count > 0) {
                    log.error((Object)"More than one user exist for the same name");
                }
                ++count;
                userObj = sr;
            }
            if (userObj != null) {
                name = userObj.getNameInNamespace();
            }
            String string = name;
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
    }

    private List<String> parseSearchResult(SearchResult sr, String groupAttributeName) {
        ArrayList<String> list = new ArrayList<String>();
        Attributes attrs = sr.getAttributes();
        if (attrs != null) {
            try {
                NamingEnumeration<? extends Attribute> ae = null;
                ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    if (groupAttributeName != null && !groupAttributeName.equals(attr.getID())) continue;
                    NamingEnumeration<?> e = null;
                    e = attr.getAll();
                    while (e.hasMore()) {
                        String value = e.next().toString();
                        int begin = value.indexOf("=") + 1;
                        int end = value.indexOf(",");
                        if (begin > -1 && end > -1) {
                            value = value.substring(begin, end);
                        }
                        list.add(value);
                    }
                    JNDIUtil.closeNamingEnumeration(e);
                }
                JNDIUtil.closeNamingEnumeration(ae);
            }
            catch (NamingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    private List<String> getAttributeListOfOneElementWithPrimarGroup(String searchBase, String searchFilter, SearchControls searchCtls, String objectSid, String primaryGroupID, String userAttributeId, String groupAttributeName) throws UserStoreException {
        List<String> list = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, searchFilter, searchCtls);
            int count = 0;
            while (answer.hasMore()) {
                if (count > 0) {
                    log.error((Object)"More than element user exist with name");
                    throw new UserStoreException("More than element user exist with name");
                }
                SearchResult sr = answer.next();
                ++count;
                list = this.parseSearchResult(sr, groupAttributeName);
                String primaryGroupSID = LDAPUtil.getPrimaryGroupSID(sr, objectSid, primaryGroupID);
                String primaryGroupName = LDAPUtil.findGroupBySID(dirContext, searchBase, primaryGroupSID, userAttributeId);
                if (primaryGroupName == null) continue;
                list.add(primaryGroupName);
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return list;
    }

    private List<String> getAttributeListOfOneElement(String searchBase, String searchFilter, SearchControls searchCtls) throws UserStoreException {
        List<String> list = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, searchFilter, searchCtls);
            int count = 0;
            while (answer.hasMore()) {
                if (count > 0) {
                    log.error((Object)"More than element user exist with name");
                    throw new UserStoreException("More than element user exist with name");
                }
                SearchResult sr = answer.next();
                ++count;
                list = this.parseSearchResult(sr, null);
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return list;
    }

    private List<String> getListOfNames(String searchBase, String searchFilter, SearchControls searchCtls, String property) throws UserStoreException {
        ArrayList<String> names = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            Serializable sr;
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                Attribute attr;
                sr = answer.next();
                if (((SearchResult)sr).getAttributes() == null || (attr = ((SearchResult)sr).getAttributes().get(property)) == null) continue;
                String name = (String)attr.get();
                names.add(name);
            }
            sr = names;
            return sr;
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
    }

    public Map<String, String> getProperties(Tenant tenant) throws org.wso2.carbon.user.api.UserStoreException {
        return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)tenant);
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws org.wso2.carbon.user.api.UserStoreException {
        ArrayList<Permission> list = new ArrayList<Permission>();
        if (permissions != null) {
            for (org.wso2.carbon.user.api.Permission permission : permissions) {
                list.add(new Permission(permission.getResourceId(), permission.getAction()));
            }
        }
        this.addRole(roleName, userList, list.toArray(new Permission[list.size()]));
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantID;
    }

    @Override
    public String[] getUserListFromProperties(String property, String value, String profileName) throws UserStoreException {
        ArrayList<String> values = new ArrayList<String>();
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        String userPropertyName = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        searchFilter = "(&" + searchFilter + "(" + property + "=" + value + "))";
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        NamingEnumeration<?> attrs = null;
        try {
            answer = this.searchForUser(searchFilter, new String[]{userPropertyName}, dirContext);
            while (answer.hasMoreElements()) {
                Attribute attribute;
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                if (attributes == null || (attribute = attributes.get(userPropertyName)) == null) continue;
                StringBuffer attrBuffer = new StringBuffer();
                attrs = attribute.getAll();
                while (attrs.hasMore()) {
                    String attr = (String)attrs.next();
                    if (attr == null || attr.trim().length() <= 0) continue;
                    attrBuffer.append(attr + ",");
                }
                String propertyValue = attrBuffer.toString();
                if (propertyValue == null || propertyValue.trim().length() <= 1) continue;
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
                values.add(propertyValue);
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public Date getPasswordExpirationTime(String username) throws UserStoreException {
        return null;
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        throw new UserStoreException("Invalid operation");
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        throw new UserStoreException("Invalid operation");
    }

    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        this.updateCredential(userName, newCredential, null);
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        this.hybridRoleManager.updateHybridRoleListOfUser(userName, deletedRoles, newRoles);
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        this.hybridRoleManager.updateUserListOfHybridRole(roleName, deletedUsers, newUsers);
        this.clearUserRolesCacheByTenant(this.tenantID);
    }

    @Override
    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return this.realmConfig.getUserStoreProperties();
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        JDBCUserStoreManager jdbcUserStore = new JDBCUserStoreManager(this.dataSource, this.realmConfig, this.realmConfig.getTenantId(), false);
        jdbcUserStore.addRememberMe(userName, token);
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            if (this.isExistingUser(userName)) {
                JDBCUserStoreManager jdbcUserStore = new JDBCUserStoreManager(this.dataSource, this.realmConfig, this.realmConfig.getTenantId(), false);
                return jdbcUserStore.isExistingRememberMeToken(userName, token);
            }
        }
        catch (Exception e) {
            log.error((Object)("Validating remember me token failed for" + userName));
        }
        return false;
    }

    public boolean isUserHasTheRole(String userName, String roleName) throws UserStoreException {
        String[] roles;
        for (String role : roles = this.getRoleListOfUser(userName)) {
            if (!role.equals(roleName)) continue;
            return true;
        }
        return false;
    }
}

