/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.persistence.CarbonAppPersistenceManager;

public class ApplicationConfiguration {
    private static final Log log = LogFactory.getLog(ApplicationConfiguration.class);
    public static final String ARTIFACTS_XML = "artifacts.xml";
    public static final String FEATURE_POSTFIX = ".feature.group";
    public static final String APPLICATION_NS = "http://products.wso2.org/carbon";
    private String appName;
    private String appVersion;
    private Artifact applicationArtifact;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationConfiguration(CarbonAppPersistenceManager capm, String appXmlPath) throws CarbonException {
        File f = new File(appXmlPath);
        if (!f.exists()) {
            throw new CarbonException("artifacts.xml file not found at : " + appXmlPath);
        }
        FileInputStream xmlInputStream = null;
        try {
            xmlInputStream = new FileInputStream(f);
            this.buildConfiguration(capm, new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement());
        }
        catch (FileNotFoundException e) {
            this.handleException("artifacts.xml File cannot be loaded from " + appXmlPath, e);
        }
        catch (XMLStreamException e) {
            this.handleException("Error while parsing the artifacts.xml file ", e);
        }
        finally {
            if (xmlInputStream != null) {
                try {
                    ((InputStream)xmlInputStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream.", (Throwable)e);
                }
            }
        }
    }

    public ApplicationConfiguration(CarbonAppPersistenceManager capm, InputStream xmlInputStream) throws CarbonException {
        try {
            this.buildConfiguration(capm, new StAXOMBuilder(xmlInputStream).getDocumentElement());
        }
        catch (XMLStreamException e) {
            this.handleException("Error while parsing the artifacts.xml file content stream", e);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public Artifact getApplicationArtifact() {
        return this.applicationArtifact;
    }

    private void buildConfiguration(CarbonAppPersistenceManager capm, OMElement documentElement) throws CarbonException {
        if (documentElement == null) {
            throw new CarbonException("Document element for artifacts.xml is null. Can't build the cApp configuration");
        }
        Iterator artifactItr = documentElement.getChildrenWithLocalName("artifact");
        Artifact appArtifact = null;
        while (artifactItr.hasNext()) {
            Artifact temp = AppDeployerUtils.populateArtifact((OMElement)artifactItr.next());
            if (!"carbon/application".equals(temp.getType())) continue;
            appArtifact = temp;
            break;
        }
        if (appArtifact == null) {
            throw new CarbonException("artifacts.xml is invalid. No Artifact found with the type - carbon/application");
        }
        this.appName = appArtifact.getName();
        this.appVersion = appArtifact.getVersion();
        String[] serverRoles = AppDeployerUtils.readServerRoles(capm);
        ArrayList<Artifact.Dependency> depsToRemove = new ArrayList<Artifact.Dependency>();
        for (Artifact.Dependency dep : appArtifact.getDependencies()) {
            boolean matched = false;
            String role = dep.getServerRole();
            for (String currentRole : serverRoles) {
                if (!role.matches(currentRole)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            depsToRemove.add(dep);
        }
        for (Artifact.Dependency item : depsToRemove) {
            appArtifact.removeDependency(item);
        }
        this.applicationArtifact = appArtifact;
    }

    private void handleException(String msg, Exception e) throws CarbonException {
        log.error((Object)msg, (Throwable)e);
        throw new CarbonException(msg, (Throwable)e);
    }
}

