/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.bootup.validator;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.bootup.validator.ConfigurationValidator;
import org.wso2.carbon.core.bootup.validator.util.UnknownParameterException;
import org.wso2.carbon.core.bootup.validator.util.ValidationResult;

public class JVMValidator
extends ConfigurationValidator {
    private static final Log log = LogFactory.getLog(JVMValidator.class);
    private RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    public static final String INIT_HEAP_MEMORY_PARAM = "initHeapSize";
    public static final String MAX_HEAP_MEMORY_PARAM = "maxHeapSize";
    public static final String MAX_PERMGEN_SIZE_PARAM = "maxPermGenSize";

    @Override
    public Map<String, ValidationResult> validate() {
        Map<String, String> recommendedConfigs = this.getRecommendedConfigurations();
        HashMap<String, ValidationResult> validationResults = new HashMap<String, ValidationResult>();
        for (String paramName : recommendedConfigs.keySet()) {
            try {
                ValidationResult result = this.validateConfiguration(paramName);
                validationResults.put(paramName, result);
            }
            catch (Exception e) {
                log.warn((Object)("Could not validate the JVM for configuration parameter : " + paramName));
                log.debug((Object)("Error occured while trying to validate configuration parameter : " + paramName), (Throwable)e);
            }
        }
        return validationResults;
    }

    protected ValidationResult validateConfiguration(String parameterName) {
        ValidationResult result;
        if (INIT_HEAP_MEMORY_PARAM.equals(parameterName)) {
            String recommendedInitHeapSize = this.getRecommendedConfigurations().get(parameterName);
            long systemInitHeapSize = this.getInitHeapSize();
            result = this.validateInitialHeapSize(systemInitHeapSize, Long.parseLong(recommendedInitHeapSize));
        } else if (MAX_HEAP_MEMORY_PARAM.equals(parameterName)) {
            String recommendedMaxHeapSize = this.getRecommendedConfigurations().get(parameterName);
            long systemMaxHeapSize = this.getMaxHeapSize();
            result = this.validateMaxHeapSize(systemMaxHeapSize, Long.parseLong(recommendedMaxHeapSize));
        } else if (MAX_PERMGEN_SIZE_PARAM.equals(parameterName)) {
            String recommendedMaxPermGen = this.getRecommendedConfigurations().get(parameterName);
            long systemMaxPermGen = this.getPermGenSize();
            result = this.validateMaxPermGenSize(systemMaxPermGen, Long.parseLong(recommendedMaxPermGen));
        } else {
            throw new UnknownParameterException(" Unknown paramater :" + parameterName);
        }
        return result;
    }

    private ValidationResult validateInitialHeapSize(long initHeapSize, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (initHeapSize >= minReq) {
            isValid = true;
        } else {
            msg = "Initial Heap Memory (MB) :" + initHeapSize + " of the running JVM is set below the recommended minimum size :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateMaxHeapSize(long maxHeapSize, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (maxHeapSize >= minReq) {
            isValid = true;
        } else {
            msg = "Maximum Heap Memory (MB) :" + maxHeapSize + " of the running JVM is set below the recommended minimum size :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private ValidationResult validateMaxPermGenSize(long maxPermSize, long minReq) {
        boolean isValid;
        ValidationResult result = new ValidationResult();
        String msg = null;
        if (maxPermSize >= minReq) {
            isValid = true;
        } else {
            msg = "Maximum PermGen space (MB) :" + maxPermSize + " of the running JVM is set below the recommended minimum size :" + minReq;
            isValid = false;
        }
        result.setValidationMessage(msg);
        result.setValid(isValid);
        return result;
    }

    private long getInitHeapSize() {
        List<String> args = this.runtimeBean.getInputArguments();
        String initHeapArg = "-Xms";
        long initHeapSize = 0L;
        for (String arg : args) {
            int endIndex;
            if (!arg.contains(initHeapArg)) continue;
            int startIndex = arg.indexOf(initHeapArg) + 4;
            String value = arg.substring(startIndex);
            if (value.contains("m") && (endIndex = value.indexOf(109)) != -1) {
                value = value.substring(0, endIndex);
            }
            initHeapSize = Long.parseLong(value);
            break;
        }
        return initHeapSize;
    }

    private long getMaxHeapSize() {
        List<String> args = this.runtimeBean.getInputArguments();
        String maxHeapArg = "-Xmx";
        long maxHeapSize = 0L;
        for (String arg : args) {
            int endIndex;
            if (!arg.contains(maxHeapArg)) continue;
            int startIndex = arg.indexOf(maxHeapArg) + 4;
            String value = arg.substring(startIndex);
            if (value.contains("m") && (endIndex = value.indexOf(109)) != -1) {
                value = value.substring(0, endIndex);
            }
            maxHeapSize = Long.parseLong(value);
            break;
        }
        return maxHeapSize;
    }

    private long getPermGenSize() {
        List<String> args = this.runtimeBean.getInputArguments();
        String permGenArg = "-XX:MaxPermSize=";
        long permGenSize = 0L;
        for (String arg : args) {
            int endIndex;
            if (!arg.contains(permGenArg)) continue;
            int startIndex = arg.indexOf(permGenArg) + 16;
            String value = arg.substring(startIndex);
            if (value.contains("m") && (endIndex = value.indexOf(109)) != -1) {
                value = value.substring(0, endIndex);
            }
            permGenSize = Long.parseLong(value);
            break;
        }
        return permGenSize;
    }
}

