/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.h2.jaqu.Db;
import org.h2.jaqu.Filter;
import org.h2.jaqu.Function;
import org.h2.jaqu.OrderExpression;
import org.h2.jaqu.QueryCondition;
import org.h2.jaqu.QueryJoin;
import org.h2.jaqu.QueryWhere;
import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.SelectColumn;
import org.h2.jaqu.SelectTable;
import org.h2.jaqu.TableDefinition;
import org.h2.jaqu.Token;
import org.h2.jaqu.bytecode.ClassReader;
import org.h2.jaqu.util.Utils;
import org.h2.util.JdbcUtils;
import org.h2.util.New;

public class Query<T> {
    private Db db;
    private SelectTable<T> from;
    private ArrayList<Token> conditions = Utils.newArrayList();
    private ArrayList<SelectTable<?>> joins = Utils.newArrayList();
    private final IdentityHashMap<Object, SelectColumn<T>> aliasMap = Utils.newIdentityHashMap();
    private ArrayList<OrderExpression<T>> orderByList = Utils.newArrayList();
    private Object[] groupByExpressions;

    Query(Db db) {
        this.db = db;
    }

    static <T> Query<T> from(Db db, T t) {
        Query<T> query = new Query<T>(db);
        TableDefinition<?> tableDefinition = db.define(t.getClass());
        query.from = new SelectTable<T>(db, query, t, false);
        tableDefinition.initSelectObject(query.from, t, query.aliasMap);
        return query;
    }

    public long selectCount() {
        SQLStatement sQLStatement = new SQLStatement(this.db);
        sQLStatement.setSQL("COUNT(*)");
        ResultSet resultSet = this.prepare(sQLStatement, false).executeQuery();
        try {
            long l;
            resultSet.next();
            long l2 = l = resultSet.getLong(1);
            return l2;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(resultSet);
        }
    }

    public List<T> select() {
        return this.select((Object)false);
    }

    public T selectFirst() {
        return (T)this.select((Object)false).get(0);
    }

    public List<T> selectDistinct() {
        return this.select((Object)true);
    }

    public <X, Z> X selectFirst(Z z) {
        List<X> list = this.select(z);
        return list.isEmpty() ? null : (X)list.get(0);
    }

    public String getSQL() {
        SQLStatement sQLStatement = new SQLStatement(this.db);
        sQLStatement.setSQL("*");
        return this.prepare(sQLStatement, false).getSQL().trim();
    }

    private List<T> select(boolean bl) {
        ArrayList arrayList = Utils.newArrayList();
        TableDefinition<T> tableDefinition = this.from.getAliasDefinition();
        SQLStatement sQLStatement = tableDefinition.getSelectList(this.db);
        ResultSet resultSet = this.prepare(sQLStatement, bl).executeQuery();
        try {
            while (resultSet.next()) {
                T t = this.from.newObject();
                this.from.getAliasDefinition().readRow(t, resultSet);
                arrayList.add(t);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(resultSet);
        }
        return arrayList;
    }

    public int delete() {
        SQLStatement sQLStatement = new SQLStatement(this.db);
        sQLStatement.appendSQL("DELETE FROM ");
        this.from.appendSQL(sQLStatement);
        this.appendWhere(sQLStatement);
        return sQLStatement.executeUpdate();
    }

    public <X, Z> List<X> selectDistinct(Z z) {
        return this.select(z, true);
    }

    public <X, Z> List<X> select(Z z) {
        return this.select(z, false);
    }

    private <X, Z> List<X> select(Z z, boolean bl) {
        Class<?> clazz = z.getClass();
        if (Utils.isSimpleType(clazz)) {
            return this.getSimple(z, bl);
        }
        clazz = clazz.getSuperclass();
        return this.select(clazz, z, bl);
    }

    private <X> List<X> select(Class<X> clazz, X x, boolean bl) {
        ArrayList arrayList = Utils.newArrayList();
        TableDefinition<X> tableDefinition = this.db.define(clazz);
        SQLStatement sQLStatement = tableDefinition.getSelectList(this, x);
        ResultSet resultSet = this.prepare(sQLStatement, bl).executeQuery();
        try {
            while (resultSet.next()) {
                X x2 = Utils.newObject(clazz);
                tableDefinition.readRow(x2, resultSet);
                arrayList.add(x2);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(resultSet);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <X> List<X> getSimple(X x, boolean bl) {
        SQLStatement sQLStatement = new SQLStatement(this.db);
        this.appendSQL(sQLStatement, x);
        ResultSet resultSet = this.prepare(sQLStatement, bl).executeQuery();
        ArrayList arrayList = Utils.newArrayList();
        try {
            while (resultSet.next()) {
                try {
                    Object object = resultSet.getObject(1);
                    arrayList.add(object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                    return arrayList;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(resultSet);
        }
    }

    public <A> QueryCondition<T, A> where(A a) {
        return new QueryCondition(this, a);
    }

    public <A> QueryWhere<T> where(Filter filter) {
        HashMap<String, Object> hashMap = New.hashMap();
        for (Field field : filter.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object exception = field.get(filter);
                if (exception == this.from.getAlias()) {
                    List<TableDefinition.FieldDefinition> list = this.from.getAliasDefinition().getFields();
                    String string = field.getName();
                    for (TableDefinition.FieldDefinition fieldDefinition : list) {
                        String string2 = string + "." + fieldDefinition.field.getName();
                        Object object = fieldDefinition.field.get(exception);
                        hashMap.put(string2, object);
                    }
                }
                hashMap.put(field.getName(), field.get(filter));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        Token token = new ClassReader().decompile(filter, hashMap, "where");
        this.conditions.add(token);
        return new QueryWhere(this);
    }

    public QueryWhere<T> whereTrue(Boolean bl) {
        Function function = new Function("", bl);
        this.addConditionToken(function);
        return new QueryWhere(this);
    }

    public Query<T> orderBy(Object ... objectArray) {
        for (Object object : objectArray) {
            OrderExpression orderExpression = new OrderExpression(this, object, false, false, false);
            this.addOrderBy(orderExpression);
        }
        return this;
    }

    public Query<T> orderByDesc(Object object) {
        OrderExpression orderExpression = new OrderExpression(this, object, true, false, false);
        this.addOrderBy(orderExpression);
        return this;
    }

    public Query<T> groupBy(Object ... objectArray) {
        this.groupByExpressions = objectArray;
        return this;
    }

    public void appendSQL(SQLStatement sQLStatement, Object object) {
        if (object == Function.count()) {
            sQLStatement.appendSQL("COUNT(*)");
            return;
        }
        Token token = Db.getToken(object);
        if (token != null) {
            token.appendSQL(sQLStatement, this);
            return;
        }
        SelectColumn<T> selectColumn = this.aliasMap.get(object);
        if (selectColumn != null) {
            selectColumn.appendSQL(sQLStatement);
            return;
        }
        sQLStatement.appendSQL("?");
        sQLStatement.addParameter(object);
    }

    void addConditionToken(Token token) {
        this.conditions.add(token);
    }

    void appendWhere(SQLStatement sQLStatement) {
        if (!this.conditions.isEmpty()) {
            sQLStatement.appendSQL(" WHERE ");
            for (Token token : this.conditions) {
                token.appendSQL(sQLStatement, this);
                sQLStatement.appendSQL(" ");
            }
        }
    }

    SQLStatement prepare(SQLStatement sQLStatement, boolean bl) {
        SQLStatement sQLStatement2 = sQLStatement;
        String string = sQLStatement2.getSQL();
        sQLStatement2.setSQL("");
        sQLStatement2.appendSQL("SELECT ");
        if (bl) {
            sQLStatement2.appendSQL("DISTINCT ");
        }
        sQLStatement2.appendSQL(string);
        sQLStatement2.appendSQL(" FROM ");
        this.from.appendSQL(sQLStatement2);
        for (SelectTable<?> object : this.joins) {
            object.appendSQLAsJoin(sQLStatement2, this);
        }
        this.appendWhere(sQLStatement2);
        if (this.groupByExpressions != null) {
            sQLStatement2.appendSQL(" GROUP BY ");
            int n = 0;
            for (Object object : this.groupByExpressions) {
                if (n++ > 0) {
                    sQLStatement2.appendSQL(", ");
                }
                this.appendSQL(sQLStatement2, object);
                sQLStatement2.appendSQL(" ");
            }
        }
        if (!this.orderByList.isEmpty()) {
            sQLStatement2.appendSQL(" ORDER BY ");
            int n = 0;
            for (OrderExpression<T> orderExpression : this.orderByList) {
                if (n++ > 0) {
                    sQLStatement2.appendSQL(", ");
                }
                orderExpression.appendSQL(sQLStatement2);
                sQLStatement2.appendSQL(" ");
            }
        }
        return sQLStatement2;
    }

    public <U> QueryJoin innerJoin(U u) {
        TableDefinition<?> tableDefinition = this.db.define(u.getClass());
        SelectTable<U> selectTable = new SelectTable<U>(this.db, this, u, false);
        tableDefinition.initSelectObject(selectTable, u, this.aliasMap);
        this.joins.add(selectTable);
        return new QueryJoin(this, selectTable);
    }

    Db getDb() {
        return this.db;
    }

    boolean isJoin() {
        return !this.joins.isEmpty();
    }

    SelectColumn<T> getSelectColumn(Object object) {
        return this.aliasMap.get(object);
    }

    void addOrderBy(OrderExpression<T> orderExpression) {
        this.orderByList.add(orderExpression);
    }
}

