/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.manager;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.stream.StreamHostObject;
import org.jaggeryjs.jaggery.core.ScriptReader;
import org.jaggeryjs.jaggery.core.manager.ModuleManager;
import org.jaggeryjs.scriptengine.cache.CacheManager;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.JavaScriptHostObject;
import org.jaggeryjs.scriptengine.engine.JavaScriptMethod;
import org.jaggeryjs.scriptengine.engine.JavaScriptModule;
import org.jaggeryjs.scriptengine.engine.JavaScriptScript;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityController;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;

public class CommonManager {
    private static final int BYTE_BUFFER_SIZE = 1024;
    private static final Log log = LogFactory.getLog(CommonManager.class);
    public static final String JAGGERY_URLS_MAP = "jaggery.urls.map";
    public static final String JAGGERY_OUTPUT_STREAM = "jaggery.output.stream";
    public static final String JAGGERY_INCLUDED_SCRIPTS = "jaggery.included.scripts";
    public static final String JAGGERY_INCLUDES_CALLSTACK = "jaggery.includes.callstack";
    public static final String JAGGERY_CORE_MANAGER = "jaggery.core.manager";
    public static final String HOST_OBJECT_NAME = "RhinoTopLevel";
    private static CommonManager manager;
    private RhinoEngine engine = null;
    private ModuleManager moduleManager = null;

    private CommonManager() throws ScriptException {
    }

    public static CommonManager getInstance() throws ScriptException {
        if (manager == null) {
            manager = new CommonManager();
        }
        return manager;
    }

    public RhinoEngine getEngine() {
        return this.engine;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public void initialize(String modulesDir, RhinoSecurityController securityController) throws ScriptException {
        this.engine = new RhinoEngine(new CacheManager(null), (SecurityController)securityController);
        this.moduleManager = new ModuleManager(modulesDir);
        CommonManager.exposeDefaultModules(this.engine, this.moduleManager.getModules());
    }

    public static void initContext(JaggeryContext context) throws ScriptException {
        context.addProperty(JAGGERY_CORE_MANAGER, (Object)manager);
        context.setEngine(CommonManager.manager.engine);
        context.setScope(CommonManager.manager.engine.getRuntimeScope());
        CommonManager.setJaggeryContext(context);
    }

    private static void exposeDefaultModules(RhinoEngine engine, Map<String, JavaScriptModule> modules) throws ScriptException {
        for (JavaScriptModule module : modules.values()) {
            if (!module.isExpose()) continue;
            String namespace = module.getNamespace();
            if (namespace == null || namespace.equals("")) {
                CommonManager.exposeModule(engine, module);
                continue;
            }
            engine.defineModule(module);
        }
    }

    public static void include(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext jaggeryContext;
        RhinoEngine engine;
        String functionName = "include";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOST_OBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)HOST_OBJECT_NAME, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if ((engine = (jaggeryContext = CommonManager.getJaggeryContext()).getEngine()) == null) {
            log.error((Object)"Rhino Engine in Jaggery context is null");
            throw new ScriptException("Rhino Engine in Jaggery context is null");
        }
        Stack<String> includesCallstack = CommonManager.getCallstack(jaggeryContext);
        Map<String, Boolean> includedScripts = CommonManager.getIncludes(jaggeryContext);
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommonManager.isHTTP(fileURL) || CommonManager.isHTTP(parent)) {
            if (!CommonManager.isHTTP(fileURL)) {
                fileURL = parent + fileURL;
            }
            if (includesCallstack.search(fileURL) != -1) {
                return;
            }
            ScriptableObject scope = jaggeryContext.getScope();
            try {
                URL url = new URL(fileURL);
                url.openConnection();
                ScriptReader source = new ScriptReader(url.openStream());
                includedScripts.put(fileURL, true);
                includesCallstack.push(fileURL);
                engine.exec((Reader)source, scope, null);
                includesCallstack.pop();
            }
            catch (MalformedURLException e) {
                String msg = "Malformed URL. function : import, url : " + fileURL;
                log.warn((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
            catch (IOException e) {
                String msg = "IO exception while importing content from url : " + fileURL;
                log.warn((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
        } else {
            String msg = "Unsupported file include : " + fileURL;
            throw new ScriptException(msg);
        }
    }

    public static void include_once(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext jaggeryContext;
        RhinoEngine engine;
        String functionName = "include_once";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOST_OBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)HOST_OBJECT_NAME, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if ((engine = (jaggeryContext = CommonManager.getJaggeryContext()).getEngine()) == null) {
            log.error((Object)"Rhino Engine in Jaggery context is null");
            throw new ScriptException("Rhino Engine in Jaggery context is null");
        }
        Stack<String> includesCallstack = CommonManager.getCallstack(jaggeryContext);
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommonManager.isHTTP(fileURL) || CommonManager.isHTTP(parent)) {
            if (!CommonManager.isHTTP(fileURL)) {
                fileURL = parent + fileURL;
            }
            if (includesCallstack.search(fileURL) != -1) {
                return;
            }
            Map<String, Boolean> includedScripts = CommonManager.getIncludes(jaggeryContext);
            if (includedScripts.get(fileURL).booleanValue()) {
                return;
            }
            ScriptableObject scope = jaggeryContext.getScope();
            try {
                URL url = new URL(fileURL);
                url.openConnection();
                ScriptReader source = new ScriptReader(url.openStream());
                includedScripts.put(fileURL, true);
                includesCallstack.push(fileURL);
                engine.exec((Reader)source, scope, null);
                includesCallstack.pop();
            }
            catch (MalformedURLException e) {
                String msg = "Malformed URL. function : import, url : " + fileURL;
                log.warn((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
            catch (IOException e) {
                String msg = "IO exception while importing content from url : " + fileURL;
                log.warn((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
        } else {
            String msg = "Unsupported file include : " + fileURL;
            throw new ScriptException(msg);
        }
    }

    public static boolean isHTTP(String url) {
        return url.matches("^[hH][tT][tT][pP][sS]?.*");
    }

    public static ScriptableObject require(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, IOException {
        String functionName = "require";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOST_OBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)HOST_OBJECT_NAME, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        String moduleName = (String)args[0];
        JaggeryContext context = CommonManager.getJaggeryContext();
        CommonManager manager = (CommonManager)context.getProperty(JAGGERY_CORE_MANAGER);
        ModuleManager moduleManager = manager.getModuleManager();
        JavaScriptModule module = moduleManager.getModules().get(moduleName);
        if (module == null) {
            String msg = "A module cannot be found with the specified name : " + moduleName;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        ScriptableObject object = (ScriptableObject)cx.newObject(thisObj);
        object.setPrototype(thisObj);
        object.setParentScope(null);
        CommonManager.exposeModule(cx, object, module);
        return object;
    }

    private static void exposeModule(Context cx, ScriptableObject object, JavaScriptModule module) throws ScriptException {
        for (JavaScriptHostObject hostObject : module.getHostObjects()) {
            RhinoEngine.defineHostObject((ScriptableObject)object, (JavaScriptHostObject)hostObject);
        }
        for (JavaScriptMethod method : module.getMethods()) {
            RhinoEngine.defineMethod((ScriptableObject)object, (JavaScriptMethod)method);
        }
        for (JavaScriptScript script : module.getScripts()) {
            script.getScript().exec(cx, (Scriptable)object);
        }
    }

    private static void exposeModule(RhinoEngine engine, JavaScriptModule module) {
        for (JavaScriptHostObject hostObject : module.getHostObjects()) {
            engine.defineHostObject(hostObject);
        }
        for (JavaScriptMethod method : module.getMethods()) {
            engine.defineMethod(method);
        }
        for (JavaScriptScript script : module.getScripts()) {
            engine.defineScript(script);
        }
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "print";
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOST_OBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        OutputStream out = (OutputStream)jaggeryContext.getProperty(JAGGERY_OUTPUT_STREAM);
        if (args[0] instanceof StreamHostObject) {
            InputStream in = ((StreamHostObject)args[0]).getStream();
            try {
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                in.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        try {
            out.write(HostObjectUtil.serializeObject((Object)args[0]).getBytes());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public static JaggeryContext getJaggeryContext() {
        return (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
    }

    public static void setJaggeryContext(JaggeryContext jaggeryContext) {
        RhinoEngine.putContextProperty((Object)"engine.jaggeryContext", (Object)jaggeryContext);
    }

    public static Map<String, Boolean> getIncludes(JaggeryContext jaggeryContext) {
        HashMap includedScripts = (HashMap)jaggeryContext.getProperty(JAGGERY_INCLUDED_SCRIPTS);
        if (includedScripts == null) {
            includedScripts = new HashMap();
            jaggeryContext.addProperty(JAGGERY_INCLUDED_SCRIPTS, includedScripts);
        }
        return includedScripts;
    }

    public static Stack<String> getCallstack(JaggeryContext jaggeryContext) {
        Stack includesCallstack = (Stack)jaggeryContext.getProperty(JAGGERY_INCLUDES_CALLSTACK);
        if (includesCallstack == null) {
            includesCallstack = new Stack();
            jaggeryContext.addProperty(JAGGERY_INCLUDES_CALLSTACK, includesCallstack);
        }
        return includesCallstack;
    }
}

