/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.realm;

import org.wso2.carbon.caching.core.BaseCache;
import org.wso2.carbon.caching.core.realm.RealmCacheEntry;
import org.wso2.carbon.caching.core.realm.RealmCacheKey;
import org.wso2.carbon.user.api.UserRealm;

public class RealmCache
extends BaseCache {
    public static final String CUSTOM_TENANT_CACHE = "CUSTOM_TENANT_CACHE";
    private static RealmCache tenantCache = null;

    private RealmCache() {
        super(CUSTOM_TENANT_CACHE);
    }

    public static synchronized RealmCache getInstance() {
        if (tenantCache == null) {
            tenantCache = new RealmCache();
        }
        return tenantCache;
    }

    public UserRealm getUserRealm(int tenantId, String realmName) {
        RealmCacheKey key = new RealmCacheKey(tenantId, realmName);
        RealmCacheEntry entry = (RealmCacheEntry)tenantCache.getValueFromCache(key);
        if (entry != null) {
            return entry.getUserRealm();
        }
        return null;
    }

    public void addToCache(int tenantId, String realmName, UserRealm userRealm) {
        tenantCache.addToCache(new RealmCacheKey(tenantId, realmName), new RealmCacheEntry(userRealm));
    }
}

