/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.policy.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.PolicyComponent;

public class OptimizePartsConfig
implements Assertion {
    public static final String OPTIMIZE_PARTS_LN = "optimizeParts";
    public static final String EXPRESSIONS_LN = "expressions";
    public static final String EXPRESSION_LN = "expression";
    public static final String NAMESPACES_LN = "namespaces";
    public static final String NAMESPACE_LN = "namespace";
    public static final String URI_ATTR = "uri";
    public static final String PREFIX_ATTR = "prefix";
    private Map namespaces = new HashMap();
    private Vector expressions = new Vector();

    public void addExpression(String expression) {
        this.expressions.add(expression);
    }

    public void addNamespaces(String prefix, String ns) {
        this.namespaces.put(prefix, ns);
    }

    public Vector getExpressions() {
        return this.expressions;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public short getType() {
        return 5;
    }

    public QName getName() {
        return new QName("http://ws.apache.org/rampart/policy", OPTIMIZE_PARTS_LN);
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = writer.getPrefix("http://ws.apache.org/rampart/policy");
        if (prefix == null) {
            prefix = "http://ws.apache.org/rampart/policy";
            writer.setPrefix(prefix, "http://ws.apache.org/rampart/policy");
        }
        writer.writeStartElement("http://ws.apache.org/rampart/policy", OPTIMIZE_PARTS_LN);
        if (this.expressions != null && this.expressions.size() > 0) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", EXPRESSIONS_LN);
            Iterator<Object> ite = this.expressions.iterator();
            while (ite.hasNext()) {
                writer.writeStartElement("http://ws.apache.org/rampart/policy", EXPRESSION_LN);
                String exp = (String)ite.next();
                writer.writeCharacters(exp);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.namespaces != null && this.namespaces.size() > 0) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", NAMESPACES_LN);
            for (String strPrefix : this.namespaces.keySet()) {
                String strURI = (String)this.namespaces.get(strPrefix);
                writer.writeStartElement("http://ws.apache.org/rampart/policy", NAMESPACE_LN);
                writer.writeAttribute(URI_ATTR, strURI);
                writer.writeAttribute(PREFIX_ATTR, strPrefix);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isOptional() {
        throw new UnsupportedOperationException("Not relevant");
    }

    public boolean equal(PolicyComponent arg0) {
        throw new UnsupportedOperationException("Not relevant");
    }
}

