/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;
import org.wso2.carbon.application.deployer.persistence.CarbonAppPersistenceManager;

public class CappAxis2Deployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(CappAxis2Deployer.class);
    private AxisConfiguration axisConfig;
    private String cAppDir;

    public void init(ConfigurationContext configurationContext) {
        File cAppDirFile;
        if (!(this.cAppDir == null || "".equals(this.cAppDir) || (cAppDirFile = new File(this.cAppDir)).exists() || cAppDirFile.mkdir())) {
            log.warn((Object)("Couldn't create directory : " + cAppDirFile.getAbsolutePath()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Capp Axis2 Deployer..");
        }
        this.axisConfig = configurationContext.getAxisConfiguration();
        this.loadPersistedApps();
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String artifactPath = deploymentFileData.getAbsolutePath();
        try {
            ApplicationManager.getInstance().deployCarbonApp(artifactPath, this.axisConfig);
        }
        catch (Exception e) {
            log.error((Object)("Error while deploying carbon application " + artifactPath), (Throwable)e);
        }
        super.deploy(deploymentFileData);
    }

    public void setDirectory(String s) {
        this.cAppDir = s;
    }

    public void setExtension(String s) {
    }

    public void undeploy(String filePath) throws DeploymentException {
        String tenantId = AppDeployerUtils.getTenantIdString(this.axisConfig);
        String artifactPath = AppDeployerUtils.formatPath(filePath);
        CarbonApplication existingApp = null;
        for (CarbonApplication carbonApp : ApplicationManager.getInstance().getCarbonApps(tenantId)) {
            if (!artifactPath.equals(carbonApp.getAppFilePath())) continue;
            existingApp = carbonApp;
            break;
        }
        if (existingApp != null) {
            ApplicationManager.getInstance().undeployCarbonApp(existingApp, this.axisConfig);
        }
        super.undeploy(filePath);
    }

    public void cleanup() throws DeploymentException {
    }

    private void loadPersistedApps() {
        try {
            CarbonAppPersistenceManager capm = ApplicationManager.getInstance().getPersistenceManager(this.axisConfig);
            capm.loadApps();
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to load persisted cApps from registry", (Throwable)e);
        }
    }
}

