/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.solr.analysis.ReversedWildcardFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;

public class SolrQueryParser
extends QueryParser {
    protected final IndexSchema schema;
    protected final QParser parser;
    protected final String defaultField;
    protected final Map<String, ReversedWildcardFilterFactory> leadingWildcards = new HashMap<String, ReversedWildcardFilterFactory>();

    public SolrQueryParser(IndexSchema schema, String defaultField) {
        super(defaultField == null ? schema.getDefaultSearchFieldName() : defaultField, schema.getQueryAnalyzer());
        this.schema = schema;
        this.parser = null;
        this.defaultField = defaultField;
        this.setLowercaseExpandedTerms(false);
        this.setEnablePositionIncrements(true);
        this.checkAllowLeadingWildcards();
    }

    public SolrQueryParser(QParser parser, String defaultField) {
        this(parser, defaultField, parser.getReq().getSchema().getQueryAnalyzer());
    }

    public SolrQueryParser(QParser parser, String defaultField, Analyzer analyzer) {
        super(defaultField, analyzer);
        this.schema = parser.getReq().getSchema();
        this.parser = parser;
        this.defaultField = defaultField;
        this.setLowercaseExpandedTerms(false);
        this.setEnablePositionIncrements(true);
        this.checkAllowLeadingWildcards();
    }

    protected void checkAllowLeadingWildcards() {
        boolean allow = false;
        for (Map.Entry<String, FieldType> e : this.schema.getFieldTypes().entrySet()) {
            TokenFilterFactory[] factories;
            Analyzer a = e.getValue().getAnalyzer();
            if (!(a instanceof TokenizerChain)) continue;
            TokenizerChain tc = (TokenizerChain)a;
            for (TokenFilterFactory factory : factories = tc.getTokenFilterFactories()) {
                if (!(factory instanceof ReversedWildcardFilterFactory)) continue;
                allow = true;
                this.leadingWildcards.put(e.getKey(), (ReversedWildcardFilterFactory)factory);
            }
        }
        if (allow) {
            this.setAllowLeadingWildcard(true);
        }
    }

    private void checkNullField(String field) throws SolrException {
        if (field == null && this.defaultField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no field name specified in query and no defaultSearchField defined in schema.xml");
        }
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        this.checkNullField(field);
        if (field.charAt(0) == '_') {
            if ("_val_".equals(field)) {
                if (this.parser == null) {
                    return QueryParsing.parseFunction(queryText, this.schema);
                }
                QParser nested = this.parser.subQuery(queryText, "func");
                return nested.getQuery();
            }
            if ("_query_".equals(field) && this.parser != null) {
                return this.parser.subQuery(queryText, null).getQuery();
            }
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        this.checkNullField(field);
        SchemaField sf = this.schema.getField(field);
        return sf.getType().getRangeQuery(this.parser, sf, "*".equals(part1) ? null : part1, "*".equals(part2) ? null : part2, inclusive, inclusive);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        this.checkNullField(field);
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        PrefixQuery prefixQuery = new PrefixQuery(t);
        return prefixQuery;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        Query q;
        if ("*".equals(field) && "*".equals(termStr)) {
            return this.newMatchAllDocsQuery();
        }
        String type = this.schema.getFieldType(field).getTypeName();
        ReversedWildcardFilterFactory factory = this.leadingWildcards.get(type);
        if (factory != null && factory.shouldReverse(termStr)) {
            termStr = ReverseStringFilter.reverse(termStr + factory.getMarkerChar());
        }
        if ((q = super.getWildcardQuery(field, termStr)) instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = new WildcardQuery(((WildcardQuery)q).getTerm());
            return wildcardQuery;
        }
        return q;
    }
}

