/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.cache;

import java.io.File;
import java.io.Reader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.cache.CachingContext;
import org.jaggeryjs.scriptengine.cache.ContextWrapper;
import org.jaggeryjs.scriptengine.cache.PackageWrapper;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.cache.TenantWrapper;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class CacheManager {
    private static final Log log = LogFactory.getLog(CacheManager.class);
    private static final String PACKAGE_NAME = "org.jaggeryjs.rhino";
    private ClassCompiler compiler;
    private ConcurrentMap<String, TenantWrapper> tenants = new ConcurrentHashMap<String, TenantWrapper>();
    private final Object lock0 = new Object();

    public CacheManager(CompilerEnvirons compilerEnv) {
        if (compilerEnv == null) {
            compilerEnv = new CompilerEnvirons();
            compilerEnv.setErrorReporter((ErrorReporter)new ToolErrorReporter(true));
        }
        this.compiler = new ClassCompiler(compilerEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(ScriptCachingContext sctx) throws ScriptException {
        Object object = this.lock0;
        synchronized (object) {
            CachingContext ctx = this.getCachingContext(sctx);
            if (ctx == null) {
                return;
            }
            TenantWrapper tenant = (TenantWrapper)this.tenants.get(ctx.getTenantId());
            tenant.removeCachingContext(sctx);
        }
    }

    public void unloadTenant(String tenantId) {
        if (tenantId == null) {
            return;
        }
        this.tenants.remove(tenantId);
    }

    public synchronized void cacheScript(Reader scriptReader, ScriptCachingContext sctx) throws ScriptException {
        String className;
        if (scriptReader == null) {
            String msg = "Unable to find the Reader for script source in CachingContext";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        TenantWrapper tenant = this.initContexts(sctx);
        CachingContext ctx = this.getCachingContext(sctx);
        if (ctx != null) {
            if (sctx.getSourceModifiedTime() <= ctx.getSourceModifiedTime()) {
                return;
            }
            className = ctx.getClassName();
            this.invalidateCache(sctx);
            ctx.setSourceModifiedTime(0L);
            ctx.setCacheUpdatedTime(0L);
        } else {
            className = CacheManager.getClassName(tenant, sctx);
            ctx = new CachingContext(sctx.getContext(), sctx.getPath(), sctx.getCacheKey());
            ctx.setTenantId(sctx.getTenantId());
            ctx.setContext(sctx.getContext());
            ctx.setPath(sctx.getPath());
            ctx.setCacheKey(sctx.getCacheKey());
            ctx.setClassName(className);
        }
        try {
            String scriptPath = sctx.getContext() + sctx.getPath() + sctx.getCacheKey();
            Object[] compiled = this.compiler.compileToClassFiles(HostObjectUtil.readerToString(scriptReader), scriptPath, 1, className);
            ctx.setScript(this.getScriptObject(compiled, sctx));
            ctx.setCacheUpdatedTime(System.currentTimeMillis());
            ctx.setSourceModifiedTime(sctx.getSourceModifiedTime());
            tenant.setCachingContext(ctx);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Script getScriptObject(Reader scriptReader, ScriptCachingContext sctx) throws ScriptException {
        CachingContext ctx = this.getCachingContext(sctx);
        if (ctx == null) {
            return null;
        }
        if (sctx.getSourceModifiedTime() > ctx.getSourceModifiedTime()) {
            this.cacheScript(scriptReader, sctx);
            ctx = this.getCachingContext(sctx);
        }
        return ctx.getScript();
    }

    public boolean isCached(ScriptCachingContext sctx) {
        return this.getCachingContext(sctx) != null;
    }

    public boolean isOlder(ScriptCachingContext sctx) {
        CachingContext ctx = this.getCachingContext(sctx);
        return ctx == null || sctx.getSourceModifiedTime() > ctx.getSourceModifiedTime();
    }

    private TenantWrapper initContexts(ScriptCachingContext sctx) {
        PackageWrapper packageWrapper;
        ContextWrapper context;
        TenantWrapper tenant = (TenantWrapper)this.tenants.get(sctx.getTenantId());
        if (tenant == null) {
            tenant = new TenantWrapper();
            this.tenants.put(sctx.getTenantId(), tenant);
        }
        if ((context = tenant.getContext(sctx)) == null) {
            context = new ContextWrapper(sctx.getContext());
            tenant.setContext(sctx, context);
        }
        if ((packageWrapper = context.getPackage(sctx.getPath())) == null) {
            packageWrapper = new PackageWrapper();
            context.setPackage(sctx.getPath(), packageWrapper);
        }
        return tenant;
    }

    private static String getClassName(TenantWrapper tenant, ScriptCachingContext sctx) throws ScriptException {
        String filteredPath = CacheManager.getPackage(sctx.getContext(), sctx.getPath());
        PackageWrapper packageWrapper = tenant.getPath(sctx);
        long classIndex = packageWrapper.getClassIndex();
        packageWrapper.setClassIndex(classIndex + 1L);
        return PACKAGE_NAME + filteredPath + ".c" + classIndex;
    }

    public static String getPackage(String context, String path) {
        path = CacheManager.normalizeForPackage(CacheManager.normalizePath(path));
        String pack = CacheManager.normalizeForPackage(CacheManager.normalizePath(context));
        if (!path.equals("")) {
            pack = pack + path;
        }
        return pack;
    }

    private static String normalizeForPackage(String path) {
        path = path.replaceAll("[-\\(\\)\\s]", "_").replace("/", ".").replaceAll("(.)([0-9])", "$1_$2");
        return path;
    }

    public static String filterNameForDir(String path) {
        path = CacheManager.normalizePath(path);
        return path.replace("/", File.separator);
    }

    public static String normalizePath(String path) {
        if (path.equals("") || path.equals("/")) {
            return "";
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    private CachingContext getCachingContext(ScriptCachingContext sctx) {
        TenantWrapper tenant = (TenantWrapper)this.tenants.get(sctx.getTenantId());
        if (tenant == null) {
            return null;
        }
        return tenant.getCachingContext(sctx);
    }

    private Script getScriptObject(Object[] compiled, ScriptCachingContext sctx) throws ScriptException {
        String className = (String)compiled[0];
        byte[] classBytes = (byte[])compiled[1];
        ClassLoader rhinoLoader = this.getClass().getClassLoader();
        try {
            GeneratedClassLoader loader = SecurityController.createLoader((ClassLoader)rhinoLoader, (Object)sctx.getSecurityDomain());
            Class cl = loader.defineClass(className, classBytes);
            loader.linkClass(cl);
            return (Script)cl.newInstance();
        }
        catch (SecurityException e) {
            throw new ScriptException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ScriptException(e);
        }
        catch (InstantiationException e) {
            throw new ScriptException(e);
        }
        catch (IllegalAccessException e) {
            throw new ScriptException(e);
        }
    }
}

