/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.task;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.internal.JaggeryCoreServiceComponent;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.WebAppContext;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskAdmin;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskConstants;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskInfo;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskUtils;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ntask.common.TaskException;

public class JaggeryTaskManager
extends ScriptableObject {
    private static final long serialVersionUID = 5003413793187124449L;
    private static final Log log = LogFactory.getLog(JaggeryTaskManager.class);

    public String getClassName() {
        return "JaggeryTaskManager";
    }

    public static String setInterval(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException, TaskException, IOException {
        String taskName = JaggeryTaskManager.getFormattedCurrentDateTime() + "-" + UIDGenerator.generateUID().substring(9);
        int argCount = arguments.length;
        Object jsFunction = null;
        Object[] functionParams = null;
        long frequency = 0L;
        Date startTime = null;
        Date endTime = null;
        HashMap<String, Object> resources = new HashMap<String, Object>();
        JaggeryTaskInfo jaggeryTaskInfo = new JaggeryTaskInfo();
        switch (argCount) {
            case 2: {
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be the execution frequency in milliseconds.");
                }
                frequency = ((Number)arguments[1]).longValue();
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(JaggeryTaskConstants.REPEAT_INDEFINITELY);
                jaggeryTaskInfo.setTaskInterval(frequency);
                break;
            }
            case 3: {
                Object[] objects;
                NativeArray nativeArray;
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be the execution frequency in milliseconds.");
                }
                frequency = ((Number)arguments[1]).longValue();
                if (arguments[2] != null) {
                    if (arguments[2] instanceof NativeArray) {
                        nativeArray = (NativeArray)arguments[2];
                        objects = nativeArray.getIds();
                        ArrayList<Object> tempParamHolder = new ArrayList<Object>();
                        for (Object currObject : objects) {
                            Object property;
                            if (currObject instanceof String) {
                                property = (String)currObject;
                                if ("length".equals(property)) continue;
                                tempParamHolder.add(nativeArray.get((String)property, (Scriptable)nativeArray));
                                continue;
                            }
                            property = (Integer)currObject;
                            tempParamHolder.add(nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray));
                        }
                        functionParams = new Object[tempParamHolder.size()];
                        tempParamHolder.toArray(functionParams);
                    } else if (arguments[2] instanceof String) {
                        taskName = (String)arguments[2];
                    } else {
                        throw new CarbonException("Invalid parameter. The third parameter must be an Array of parameters to the argument, a string value for the task name or null.");
                    }
                }
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(JaggeryTaskConstants.REPEAT_INDEFINITELY);
                jaggeryTaskInfo.setTaskInterval(frequency);
                break;
            }
            case 4: {
                Object[] objects;
                NativeArray nativeArray;
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be the execution frequency in milliseconds.");
                }
                frequency = ((Number)arguments[1]).longValue();
                if (arguments[2] != null) {
                    if (arguments[2] instanceof NativeArray) {
                        nativeArray = (NativeArray)arguments[2];
                        objects = nativeArray.getIds();
                        ArrayList<Object> tempParamHolder = new ArrayList<Object>();
                        for (Object currObject : objects) {
                            Object property;
                            if (currObject instanceof String) {
                                property = (String)currObject;
                                if ("length".equals(property)) continue;
                                tempParamHolder.add(nativeArray.get((String)property, (Scriptable)nativeArray));
                                continue;
                            }
                            property = (Integer)currObject;
                            tempParamHolder.add(nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray));
                        }
                        functionParams = new Object[tempParamHolder.size()];
                        tempParamHolder.toArray(functionParams);
                    } else {
                        throw new CarbonException("Invalid parameter. The third parameter must be an Array of parameters to the argument or null.");
                    }
                }
                if (arguments[3] != null) {
                    if (arguments[3] instanceof String) {
                        taskName = (String)arguments[3];
                    } else {
                        try {
                            startTime = (Date)Context.jsToJava((Object)arguments[3], Date.class);
                        }
                        catch (EvaluatorException e) {
                            throw new CarbonException("Invalid parameter. The fourth parameter must be the start time in date format or a string value for the task name.", (Throwable)e);
                        }
                    }
                }
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(JaggeryTaskConstants.REPEAT_INDEFINITELY);
                jaggeryTaskInfo.setTaskInterval(frequency);
                jaggeryTaskInfo.setStartTime(JaggeryTaskUtils.dateToCal(startTime));
                break;
            }
            case 5: {
                Object[] objects;
                NativeArray nativeArray;
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be the execution frequency in milliseconds.");
                }
                frequency = ((Number)arguments[1]).longValue();
                if (arguments[2] != null) {
                    if (arguments[2] instanceof NativeArray) {
                        nativeArray = (NativeArray)arguments[2];
                        objects = nativeArray.getIds();
                        ArrayList<Object> tempParamHolder = new ArrayList<Object>();
                        for (Object currObject : objects) {
                            Object property;
                            if (currObject instanceof String) {
                                property = (String)currObject;
                                if ("length".equals(property)) continue;
                                tempParamHolder.add(nativeArray.get((String)property, (Scriptable)nativeArray));
                                continue;
                            }
                            property = (Integer)currObject;
                            tempParamHolder.add(nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray));
                        }
                        functionParams = new Object[tempParamHolder.size()];
                        tempParamHolder.toArray(functionParams);
                    } else {
                        throw new CarbonException("Invalid parameter. The third parameter must be an Array of parameters to the argument or null.");
                    }
                }
                if (arguments[3] != null) {
                    if (arguments[3] instanceof String) {
                        taskName = (String)arguments[3];
                    } else {
                        try {
                            startTime = (Date)Context.jsToJava((Object)arguments[3], Date.class);
                        }
                        catch (EvaluatorException e) {
                            throw new CarbonException("Invalid parameter. The fourth parameter must be the start time in date format.", (Throwable)e);
                        }
                    }
                }
                if (arguments[4] != null) {
                    if (arguments[4] instanceof String) {
                        taskName = (String)arguments[4];
                    } else {
                        try {
                            endTime = (Date)Context.jsToJava((Object)arguments[4], Date.class);
                        }
                        catch (EvaluatorException e) {
                            throw new CarbonException("Invalid parameter. The fifth parameter must be the end time in date format or a string value for the task name.", (Throwable)e);
                        }
                    }
                }
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(JaggeryTaskConstants.REPEAT_INDEFINITELY);
                jaggeryTaskInfo.setTaskInterval(frequency);
                jaggeryTaskInfo.setStartTime(JaggeryTaskUtils.dateToCal(startTime));
                jaggeryTaskInfo.setEndTime(JaggeryTaskUtils.dateToCal(endTime));
                break;
            }
            case 6: {
                Object[] objects;
                NativeArray nativeArray;
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be the execution frequency in milliseconds.");
                }
                frequency = ((Number)arguments[1]).longValue();
                if (arguments[2] != null) {
                    if (arguments[2] instanceof NativeArray) {
                        nativeArray = (NativeArray)arguments[2];
                        objects = nativeArray.getIds();
                        ArrayList<Object> tempParamHolder = new ArrayList<Object>();
                        for (Object currObject : objects) {
                            Object property;
                            if (currObject instanceof String) {
                                property = (String)currObject;
                                if ("length".equals(property)) continue;
                                tempParamHolder.add(nativeArray.get((String)property, (Scriptable)nativeArray));
                                continue;
                            }
                            property = (Integer)currObject;
                            tempParamHolder.add(nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray));
                        }
                        functionParams = new Object[tempParamHolder.size()];
                        tempParamHolder.toArray(functionParams);
                    } else {
                        throw new CarbonException("Invalid parameter. The third parameter must be an Array of parameters to the argument or null.");
                    }
                }
                if (arguments[3] != null) {
                    try {
                        startTime = (Date)Context.jsToJava((Object)arguments[3], Date.class);
                    }
                    catch (EvaluatorException e) {
                        throw new CarbonException("Invalid parameter. The fourth parameter must be the start time in date format.", (Throwable)e);
                    }
                }
                if (arguments[4] != null) {
                    try {
                        endTime = (Date)Context.jsToJava((Object)arguments[4], Date.class);
                    }
                    catch (EvaluatorException e) {
                        throw new CarbonException("Invalid parameter. The fifth parameter must be the end time in date format.", (Throwable)e);
                    }
                }
                if (arguments[5] != null) {
                    if (arguments[5] instanceof String) {
                        taskName = (String)arguments[5];
                    } else {
                        throw new CarbonException("Invalid parameter. The sixth parameter must be a string value for the task name");
                    }
                }
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(JaggeryTaskConstants.REPEAT_INDEFINITELY);
                jaggeryTaskInfo.setTaskInterval(frequency);
                jaggeryTaskInfo.setStartTime(JaggeryTaskUtils.dateToCal(startTime));
                jaggeryTaskInfo.setEndTime(JaggeryTaskUtils.dateToCal(endTime));
                break;
            }
            default: {
                throw new CarbonException("Invalid number of parameters.");
            }
        }
        JaggeryTaskManager.addCommonResources(cx, taskName, jsFunction, functionParams, resources);
        JaggeryCoreServiceComponent.getTaskMap().put(taskName, resources);
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("taskName", taskName);
        jaggeryTaskInfo.setTaskProperties(propertyMap);
        JaggeryTaskAdmin taskAdmin = new JaggeryTaskAdmin();
        try {
            taskAdmin.scheduleTask(jaggeryTaskInfo);
        }
        catch (TaskException e) {
            throw new CarbonException("Unable to create the scheduling task");
        }
        return taskName;
    }

    public static void clearInterval(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        if (!(arguments[0] instanceof String)) {
            throw new CarbonException("Invalid parameter");
        }
        JaggeryTaskManager.deleteJob(arguments);
    }

    private static void deleteJob(Object[] arguments) {
        String taskName = (String)arguments[0];
        JaggeryTaskAdmin taskAdmin = new JaggeryTaskAdmin();
        try {
            taskAdmin.deleteTask(taskName);
        }
        catch (TaskException e) {
            log.error((Object)("Unable to delete job : " + e.getMessage()));
        }
    }

    public static boolean isTaskScheduled(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException, TaskException {
        if (arguments[0] instanceof String) {
            JaggeryTaskAdmin taskAdmin = new JaggeryTaskAdmin();
            return taskAdmin.isTaskScheduled((String)arguments[0]);
        }
        return false;
    }

    public static String setTimeout(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException, IOException {
        String taskName = JaggeryTaskManager.getFormattedCurrentDateTime() + "-" + UIDGenerator.generateUID().substring(9);
        int argCount = arguments.length;
        Object jsFunction = null;
        Object[] functionParams = null;
        long timeout = 0L;
        Date currentTime = new Date();
        HashMap<String, Object> resources = new HashMap<String, Object>();
        JaggeryTaskInfo jaggeryTaskInfo = new JaggeryTaskInfo();
        switch (argCount) {
            case 2: {
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be function starting timeout.");
                }
                timeout = ((Number)arguments[1]).longValue();
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(0);
                jaggeryTaskInfo.setTaskInterval(0L);
                jaggeryTaskInfo.setStartTime(JaggeryTaskUtils.dateToCal(new Date(currentTime.getTime() + timeout)));
                break;
            }
            case 3: {
                if (!(arguments[0] instanceof Function) && !(arguments[0] instanceof String)) {
                    throw new CarbonException("Invalid parameter. The first parameter must be a JavaScript function.");
                }
                jsFunction = arguments[0];
                if (arguments[1] == null || !(arguments[1] instanceof Number)) {
                    throw new CarbonException("Invalid parameter. The second parameter must be the execution frequency in milliseconds.");
                }
                timeout = ((Number)arguments[1]).longValue();
                if (arguments[2] != null) {
                    if (arguments[2] instanceof String) {
                        taskName = (String)arguments[2];
                    } else {
                        throw new CarbonException("Invalid parameter. The third parameter must be a string value for the  the task name");
                    }
                }
                jaggeryTaskInfo.setName(taskName);
                jaggeryTaskInfo.setTaskCount(0);
                jaggeryTaskInfo.setTaskInterval(0L);
                jaggeryTaskInfo.setStartTime(JaggeryTaskUtils.dateToCal(new Date(currentTime.getTime() + timeout)));
                break;
            }
            default: {
                throw new CarbonException("Invalid number of parameters.");
            }
        }
        JaggeryTaskManager.addCommonResources(cx, taskName, jsFunction, functionParams, resources);
        JaggeryCoreServiceComponent.getTaskMap().put(taskName, resources);
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("taskName", taskName);
        jaggeryTaskInfo.setTaskProperties(propertyMap);
        JaggeryTaskAdmin taskAdmin = new JaggeryTaskAdmin();
        try {
            taskAdmin.scheduleTask(jaggeryTaskInfo);
        }
        catch (TaskException e) {
            throw new CarbonException("Unable to create the scheduling task");
        }
        return taskName;
    }

    private static void addCommonResources(Context cx, String taskName, Object jsFunction, Object[] functionParams, Map<String, Object> resources) {
        resources.put("jsfunctionarguments", functionParams);
        resources.put("taskName", taskName);
        resources.put("jsfunction", jsFunction);
        resources.put("contextFactory", cx.getFactory());
        resources.put("fileManager", RhinoEngine.getContextProperty((Object)"hostobjects.file.filemanager"));
        resources.put("scriptPath", CommonManager.getJaggeryContext().getIncludesCallstack().peek());
        resources.put("servletContext", ((WebAppContext)CommonManager.getJaggeryContext()).getServletConext());
    }

    public static void clearTimeout(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws CarbonException {
        if (!(arguments[0] instanceof String)) {
            throw new CarbonException("Invalid parameter");
        }
        JaggeryTaskManager.deleteJob(arguments);
    }

    private static String getFormattedCurrentDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS-z");
        Date date = new Date();
        return dateFormat.format(date);
    }
}

