/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDTextStream;
import org.pdfbox.pdmodel.fdf.FDFField;
import org.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.pdfbox.util.BitFlagHelper;

public abstract class PDField
implements COSObjectable {
    public static final int FLAG_READ_ONLY = 1;
    public static final int FLAG_REQUIRED = 2;
    public static final int FLAG_NO_EXPORT = 4;
    private PDAcroForm acroForm;
    private COSDictionary dictionary;

    public PDField(PDAcroForm theAcroForm) {
        this.acroForm = theAcroForm;
        this.dictionary = new COSDictionary();
    }

    public PDField(PDAcroForm theAcroForm, COSDictionary field) {
        this.acroForm = theAcroForm;
        this.dictionary = field;
    }

    public String getPartialName() {
        return this.getDictionary().getString("T");
    }

    public void setPartialName(String name) {
        this.getDictionary().setString("T", name);
    }

    public String getFullyQualifiedName() throws IOException {
        PDField parent = this.getParent();
        String parentName = null;
        if (parent != null) {
            parentName = parent.getFullyQualifiedName();
        }
        String finalName = this.getPartialName();
        if (parentName != null) {
            finalName = parentName + "." + finalName;
        }
        return finalName;
    }

    public String getFieldType() {
        return this.getDictionary().getNameAsString("FT");
    }

    public String findFieldType() {
        return this.findFieldType(this.getDictionary());
    }

    private String findFieldType(COSDictionary dic) {
        COSDictionary parent;
        String retval = dic.getNameAsString("FT");
        if (retval == null && (parent = (COSDictionary)dic.getDictionaryObject("Parent", "P")) != null) {
            retval = this.findFieldType(parent);
        }
        return retval;
    }

    public abstract void setValue(String var1) throws IOException;

    public abstract String getValue() throws IOException;

    public void setReadonly(boolean readonly) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 1, readonly);
    }

    public boolean isReadonly() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 1);
    }

    public void setRequired(boolean required) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 2, required);
    }

    public boolean isRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 2);
    }

    public void setNoExport(boolean noExport) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 4, noExport);
    }

    public boolean isNoExport() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 4);
    }

    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getDictionary().getDictionaryObject(COSName.getPDFName("Ff"));
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setFieldFlags(int flags) {
        COSInteger ff = new COSInteger(flags);
        this.getDictionary().setItem(COSName.getPDFName("Ff"), (COSBase)ff);
    }

    public void importFDF(FDFField fdfField) throws IOException {
        Integer ff;
        Object fieldValue = fdfField.getValue();
        int fieldFlags = this.getFieldFlags();
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                this.setValue((String)fieldValue);
            } else if (fieldValue instanceof PDTextStream) {
                this.setValue(((PDTextStream)fieldValue).getAsString());
            } else {
                throw new IOException("Unknown field type:" + fieldValue.getClass().getName());
            }
        }
        if ((ff = fdfField.getFieldFlags()) != null) {
            this.setFieldFlags(ff);
        } else {
            Integer clrFf;
            Integer setFf = fdfField.getSetFieldFlags();
            if (setFf != null) {
                int setFfInt = setFf;
                this.setFieldFlags(fieldFlags |= setFfInt);
            }
            if ((clrFf = fdfField.getClearFieldFlags()) != null) {
                int clrFfValue = clrFf;
                this.setFieldFlags(fieldFlags &= (clrFfValue ^= 0xFFFFFFFF));
            }
        }
        PDAnnotationWidget widget = this.getWidget();
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            Integer f = fdfField.getWidgetFieldFlags();
            if (f != null && widget != null) {
                widget.setAnnotationFlags(f);
            } else {
                Integer clrF;
                Integer setF = fdfField.getSetWidgetFieldFlags();
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = fdfField.getClearWidgetFieldFlags()) != null) {
                    int clrFValue = clrF;
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
        List fdfKids = fdfField.getKids();
        List pdKids = this.getKids();
        for (int i = 0; fdfKids != null && i < fdfKids.size(); ++i) {
            FDFField fdfChild = (FDFField)fdfKids.get(i);
            String fdfName = fdfChild.getPartialFieldName();
            for (int j = 0; j < pdKids.size(); ++j) {
                Object pdChildObj = pdKids.get(j);
                if (!(pdChildObj instanceof PDField)) continue;
                PDField pdChild = (PDField)pdChildObj;
                if (fdfName == null || !fdfName.equals(pdChild.getPartialName())) continue;
                pdChild.importFDF(fdfChild);
            }
        }
    }

    public PDAnnotationWidget getWidget() throws IOException {
        Object firstKid;
        PDAnnotationWidget retval = null;
        List kids = this.getKids();
        retval = kids == null ? new PDAnnotationWidget(this.getDictionary()) : (kids.size() > 0 ? ((firstKid = kids.get(0)) instanceof PDAnnotationWidget ? (PDAnnotationWidget)firstKid : ((PDField)firstKid).getWidget()) : null);
        return retval;
    }

    public PDField getParent() throws IOException {
        PDField parent = null;
        COSDictionary parentDic = (COSDictionary)this.getDictionary().getDictionaryObject("Parent");
        if (parentDic != null) {
            parent = PDFieldFactory.createField(this.getAcroForm(), parentDic);
        }
        return parent;
    }

    public void setParent(PDField parent) {
        this.getDictionary().setItem("Parent", (COSObjectable)parent);
    }

    public PDField findKid(String[] name, int nameIndex) throws IOException {
        PDField retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            for (int i = 0; retval == null && i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                if (!name[nameIndex].equals(kidDictionary.getString("T"))) continue;
                retval = PDFieldFactory.createField(this.acroForm, kidDictionary);
                if (name.length <= nameIndex + 1) continue;
                retval = retval.findKid(name, nameIndex + 1);
            }
        }
        return retval;
    }

    public List getKids() throws IOException {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<COSObjectable> kidsList = new ArrayList<COSObjectable>();
            for (int i = 0; i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                COSDictionary parent = (COSDictionary)kidDictionary.getDictionaryObject("Parent");
                if (kidDictionary.getDictionaryObject("FT") != null || parent != null && parent.getDictionaryObject("FT") != null) {
                    kidsList.add(PDFieldFactory.createField(this.acroForm, kidDictionary));
                    continue;
                }
                if ("Widget".equals(kidDictionary.getNameAsString("Subtype"))) {
                    kidsList.add(new PDAnnotationWidget(kidDictionary));
                    continue;
                }
                kidsList.add(PDFieldFactory.createField(this.acroForm, kidDictionary));
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(kids);
        this.getDictionary().setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    public String toString() {
        return "" + this.getDictionary().getDictionaryObject(COSName.getPDFName("V"));
    }

    public PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm value) {
        this.acroForm = value;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public PDFormFieldAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.dictionary.getDictionaryObject("AA");
        PDFormFieldAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDFormFieldAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDFormFieldAdditionalActions actions) {
        this.dictionary.setItem("AA", (COSObjectable)actions);
    }
}

