/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationXMLFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(ApplicationXMLFormatter.class);

    @Override
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        return this.getBytes(messageContext, format, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getBytes()");
            log.debug((Object)("  fault flow=" + (messageContext.getFLOW() == 4)));
        }
        try {
            byte[] byArray;
            OMElement omElement;
            if (messageContext.getFLOW() == 4) {
                SOAPFault fault = messageContext.getEnvelope().getBody().getFault();
                SOAPFaultDetail soapFaultDetail = fault.getDetail();
                omElement = soapFaultDetail.getFirstElement();
                if (omElement == null) {
                    omElement = fault.getReason();
                }
            } else {
                omElement = messageContext.getEnvelope().getBody().getFirstElement();
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            if (omElement != null) {
                try {
                    if (preserve) {
                        omElement.serialize((OutputStream)bytesOut, format);
                    } else {
                        omElement.serializeAndConsume((OutputStream)bytesOut, format);
                    }
                }
                catch (XMLStreamException e) {
                    throw AxisFault.makeFault(e);
                }
                byArray = bytesOut.toByteArray();
                return byArray;
            }
            byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"end getBytes()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeTo()");
        }
        try {
            OMElement omElement = null;
            if (messageContext.getFLOW() == 4) {
                SOAPFault fault = messageContext.getEnvelope().getBody().getFault();
                SOAPFaultDetail soapFaultDetail = fault.getDetail();
                if (soapFaultDetail != null) {
                    omElement = soapFaultDetail.getFirstElement();
                }
                if (omElement == null) {
                    omElement = fault.getReason();
                }
            } else {
                omElement = messageContext.getEnvelope().getBody().getFirstElement();
            }
            if (omElement != null) {
                try {
                    if (preserve) {
                        omElement.serialize(outputStream, format);
                    } else {
                        omElement.serializeAndConsume(outputStream, format);
                    }
                }
                catch (XMLStreamException e) {
                    throw AxisFault.makeFault(e);
                }
            }
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"end writeTo()");
            }
        }
    }

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = (String)messageContext.getProperty("ContentType");
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType set from messageContext =" + contentType));
            log.debug((Object)("(NOTE) contentType from format is=" + format.getContentType()));
        }
        if (contentType == null) {
            contentType = "application/xml";
        } else if (this.isSOAPContentType(contentType)) {
            contentType = "application/xml";
            if (log.isDebugEnabled()) {
                log.debug((Object)"contentType is set incorrectly for Application XML.");
                log.debug((Object)("It is changed to " + contentType));
            }
        }
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType returned =" + contentType));
        }
        return contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }

    private boolean isSOAPContentType(String contentType) {
        if (JavaUtils.indexOfIgnoreCase(contentType, "application/soap+xml") > -1) {
            return true;
        }
        return JavaUtils.indexOfIgnoreCase(contentType, "text/xml") > -1;
    }
}

