/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.message.databinding.DataSourceBlock;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(ApplicationXMLFormatter.class);
    private final String contentType;

    public DataSourceFormatter(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        throw new UnsupportedOperationException("FIXME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        block15: {
            AttachmentsAdapter attachments = (AttachmentsAdapter)messageContext.getProperty("javax.xml.ws.binding.attachments.outbound");
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"start writeTo()");
                }
                if (attachments != null && !attachments.isEmpty()) {
                    DataSource busObject;
                    OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
                    try {
                        busObject = (DataSource)((DataSourceBlock)((OMSourcedElement)omElement).getDataSource()).getBusinessObject(true);
                    }
                    catch (XMLStreamException e) {
                        throw AxisFault.makeFault(e);
                    }
                    MIMEOutputUtils.writeDataHandlerWithAttachmentsMessage((DataHandler)new DataHandler(busObject), (String)this.contentType, (OutputStream)outputStream, (Map)attachments, (OMOutputFormat)format);
                    break block15;
                }
                OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
                if (omElement != null) {
                    try {
                        if (preserve) {
                            omElement.serialize(outputStream, format);
                        } else {
                            omElement.serializeAndConsume(outputStream, format);
                        }
                    }
                    catch (XMLStreamException e) {
                        throw AxisFault.makeFault(e);
                    }
                }
                try {
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw AxisFault.makeFault(e);
                }
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"end writeTo()");
                }
            }
        }
    }

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        AttachmentsAdapter attachments = (AttachmentsAdapter)messageContext.getProperty("javax.xml.ws.binding.attachments.outbound");
        if (attachments != null && !attachments.isEmpty()) {
            return format.getContentTypeForSwA(this.contentType);
        }
        return this.contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }
}

