/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceManager;

public class DataSourceStatMessage
extends ClusteringMessage {
    private static final long serialVersionUID = 8026941529427128824L;
    private static Log log = LogFactory.getLog(DataSourceStatMessage.class);
    private String dsName;
    private int tenantId;

    public ClusteringCommand getResponse() {
        return null;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void execute(ConfigurationContext configCtx) throws ClusteringFault {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cluster message arrived for tenant: " + this.getTenantId() + " datasource: " + this.getDsName()));
            }
            DataSourceManager.getInstance().getDataSourceRepository().refreshUserDataSource(this.getDsName());
        }
        catch (DataSourceException e) {
            throw new ClusteringFault("Error in handling data source stat message: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

