/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.io.Serializable;
import java.util.Set;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.CacheInvalidator;
import org.wso2.carbon.caching.core.rolesofuser.UserRolesCacheEntry;
import org.wso2.carbon.caching.core.rolesofuser.UserRolesCacheKey;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;

public class UserRolesCache {
    private static Log log = LogFactory.getLog(UserRolesCache.class);
    private Cache cache = CarbonUtils.getLocalCache((String)"USER_ROLES_CACHE");
    private static final String USER_ROLES_CACHE = "USER_ROLES_CACHE";
    private static UserRolesCache userRolesCache = new UserRolesCache();

    private UserRolesCache() {
    }

    public static UserRolesCache getInstance() {
        return userRolesCache;
    }

    private boolean isCacheNull() {
        if (this.cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("USER_ROLES_CAHCHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    public void addToCache(String serverId, int tenantId, String userName, String[] userRoleList) {
        if (this.isCacheNull()) {
            return;
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
        UserRolesCacheEntry userRolesCacheEntry = new UserRolesCacheEntry(userRoleList);
        this.cache.put((Object)userRolesCacheKey, (Object)userRolesCacheEntry);
    }

    public String[] getRolesListOfUser(String serverId, int tenantId, String userName) {
        if (this.isCacheNull()) {
            return new String[0];
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
        UserRolesCacheEntry userRolesCacheEntry = (UserRolesCacheEntry)this.cache.get((Object)userRolesCacheKey);
        String[] roleList = userRolesCacheEntry.getUserRolesList();
        return roleList;
    }

    public void clearCacheByTenant(int tenantId) {
        if (this.isCacheNull()) {
            return;
        }
        Set objectSet = this.cache.keySet();
        for (Object object : objectSet) {
            UserRolesCacheKey userRolesCacheKey = (UserRolesCacheKey)object;
            if (tenantId != userRolesCacheKey.getTenantId()) continue;
            this.cache.remove((Object)userRolesCacheKey);
        }
        CacheInvalidator invalidator = UMListenerServiceComponent.getCacheInvalidator();
        try {
            if (invalidator != null) {
                invalidator.invalidateCache(USER_ROLES_CACHE, (Serializable)Integer.valueOf(tenantId));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Calling invalidation cache");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not calling invalidation cache");
            }
        }
        catch (CacheException e) {
            log.error((Object)"Error while invalidating cache", (Throwable)e);
        }
    }

    public void clearCacheEntry(String serverId, int tenantId, String userName) {
        if (this.isCacheNull()) {
            return;
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
        if (this.cache.containsKey((Object)userRolesCacheKey)) {
            this.cache.remove((Object)userRolesCacheKey);
        }
    }
}

