/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.util.Properties;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JGroupsCacheReplicatorFactory
extends CacheEventListenerFactory {
    private static final String ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS = "asynchronousReplicationIntervalMillis";
    private static final Log LOG = LogFactory.getLog(JGroupsCacheReplicatorFactory.class);
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";

    public CacheEventListener createCacheEventListener(Properties properties) {
        LOG.debug((Object)"making new cache rep");
        boolean replicatePuts = this.extractBooleanProperty(properties, REPLICATE_PUTS, true);
        boolean replicateUpdates = this.extractBooleanProperty(properties, REPLICATE_UPDATES, true);
        boolean replicateUpdatesViaCopy = this.extractBooleanProperty(properties, REPLICATE_UPDATES_VIA_COPY, false);
        boolean replicateRemovals = this.extractBooleanProperty(properties, REPLICATE_REMOVALS, true);
        boolean replicateAsync = this.extractBooleanProperty(properties, REPLICATE_ASYNCHRONOUSLY, true);
        long asyncTime = this.extractAsynchronousReplicationIntervalMillis(properties, ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS, 1000L);
        JGroupsCacheReplicator r = new JGroupsCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, replicateAsync);
        if (r.isReplicateAsync()) {
            r.setAsynchronousReplicationInterval(asyncTime);
        }
        return r;
    }

    protected long extractAsynchronousReplicationIntervalMillis(Properties properties, String propertyName, long defaultValue) {
        String parsedString = PropertyUtil.extractAndLogProperty(propertyName, properties);
        if (parsedString != null) {
            try {
                Long longValue = new Long(parsedString);
                return longValue;
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Number format exception trying to set asynchronousReplicationIntervalMillis. Using the default instead. String value was: '" + parsedString + "'"));
            }
        }
        return defaultValue;
    }

    protected boolean extractBooleanProperty(Properties properties, String propertyName, boolean defaultValue) {
        String pString = PropertyUtil.extractAndLogProperty(propertyName, properties);
        boolean ret = pString != null ? PropertyUtil.parseBoolean(pString) : defaultValue;
        return ret;
    }
}

