/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Activator;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.eclipse.equinox.http.servlet.internal.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.ServletConfigImpl;
import org.eclipse.equinox.http.servlet.internal.ServletContextAdaptor;
import org.eclipse.equinox.http.servlet.internal.ServletRegistration;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    private Map registrations = new HashMap();
    private Set servlets = new HashSet();
    private ProxyContext proxyContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.proxyContext = new ProxyContext(config.getServletContext());
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.removeProxyServlet(this);
        this.proxyContext.destroy();
        this.proxyContext = null;
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.proxyContext.initializeServletPath(req);
        String alias = HttpServletRequestAdaptor.getDispatchPathInfo(req);
        if (alias == null) {
            alias = "/";
        }
        if (this.processAlias(req, resp, alias, null)) {
            return;
        }
        String extensionAlias = this.findExtensionAlias(alias);
        alias = alias.substring(0, alias.lastIndexOf(47));
        while (alias.length() != 0) {
            if (this.processAlias(req, resp, alias, extensionAlias)) {
                return;
            }
            alias = alias.substring(0, alias.lastIndexOf(47));
        }
        if (extensionAlias != null) {
            extensionAlias = extensionAlias.substring(1);
        }
        if (this.processAlias(req, resp, "/", extensionAlias)) {
            return;
        }
        resp.sendError(404, "ProxyServlet: " + req.getRequestURI());
    }

    private String findExtensionAlias(String alias) {
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        int dot = lastSegment.indexOf(46);
        if (dot == -1) {
            return null;
        }
        String extension = lastSegment.substring(dot + 1);
        if (extension.length() == 0) {
            return null;
        }
        return "/*." + extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAlias(HttpServletRequest req, HttpServletResponse resp, String alias, String extensionAlias) throws ServletException, IOException {
        Registration registration = null;
        ProxyServlet proxyServlet = this;
        synchronized (proxyServlet) {
            if (extensionAlias == null) {
                registration = (Registration)this.registrations.get(alias);
            } else {
                registration = (Registration)this.registrations.get(alias + extensionAlias);
                if (registration != null) {
                    if (registration instanceof ServletRegistration) {
                        alias = HttpServletRequestAdaptor.getDispatchPathInfo(req);
                    }
                } else {
                    registration = (Registration)this.registrations.get(alias);
                }
            }
            if (registration != null) {
                registration.addReference();
            }
        }
        if (registration != null) {
            try {
                if (registration.handleRequest(req, resp, alias)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                registration.removeReference();
            }
        }
        return false;
    }

    synchronized void unregister(String alias, boolean destroy) {
        Registration removedRegistration = (Registration)this.registrations.remove(alias);
        if (removedRegistration != null) {
            if (destroy) {
                removedRegistration.destroy();
            }
            removedRegistration.close();
        }
    }

    synchronized void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context, Bundle bundle) throws ServletException, NamespaceException {
        this.checkAlias(alias);
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        ServletRegistration registration = new ServletRegistration(servlet, this.proxyContext, context, bundle, this.servlets);
        registration.checkServletRegistration();
        ServletContextAdaptor wrappedServletContext = new ServletContextAdaptor(this.proxyContext, this.getServletContext(), context, AccessController.getContext());
        ServletConfigImpl servletConfig = new ServletConfigImpl(servlet, initparams, wrappedServletContext);
        registration.init(servletConfig);
        this.registrations.put(alias, registration);
    }

    synchronized void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        this.checkAlias(alias);
        this.checkName(name);
        this.registrations.put(alias, new ResourceRegistration(name, context, this.getServletContext(), AccessController.getContext()));
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.endsWith("/") && !name.equals("/")) {
            throw new IllegalArgumentException("Invalid Name '" + name + "'");
        }
    }

    private void checkAlias(String alias) throws NamespaceException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (!alias.startsWith("/") || alias.endsWith("/") && !alias.equals("/")) {
            throw new IllegalArgumentException("Invalid alias '" + alias + "'");
        }
        if (this.registrations.containsKey(alias)) {
            throw new NamespaceException("The alias '" + alias + "' is already in use.");
        }
    }
}

