/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl.remote;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskManager;
import org.wso2.carbon.ntask.core.impl.remote.RemoteTaskUtils;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public class RemoteTaskCallbackServlet
extends HttpServlet {
    private final Log log = LogFactory.getLog(RemoteTaskCallbackServlet.class);
    private static final long serialVersionUID = -8777558000344655739L;
    public static final String REMOTE_SYSTEM_TASK_HEADER_ID = "REMOTE_SYSTEM_TASK_ID";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        try {
            String remoteTaskId = req.getHeader(REMOTE_SYSTEM_TASK_HEADER_ID);
            if (remoteTaskId == null) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Remote Task Request Received: " + remoteTaskId));
            }
            Object[] taskInfo = RemoteTaskUtils.lookupRemoteTask(remoteTaskId);
            int tenantId = (Integer)taskInfo[0];
            String taskType = (String)taskInfo[1];
            String taskName = (String)taskInfo[2];
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getCurrentContext().setTenantId(tenantId);
                TaskManager tm = TasksDSComponent.getTaskService().getTaskManager(taskType);
                if (!(tm instanceof RemoteTaskManager)) {
                    this.log.error((Object)("The server is not running in remote task mode, the current task manager type used is '" + tm.getClass() + "'"));
                    return;
                }
                ((RemoteTaskManager)tm).runTask(taskName);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error in executing remote task request: " + e.getMessage()), (Throwable)e);
        }
    }
}

